/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.DateCalculationException;
import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface Calendar {
    public static final int MAX_ITERATIONS = 3650;

    public boolean isHoliday(LocalDate var1);

    public Set<Holiday> getHolidaysFor(LocalDate var1);

    default public boolean isBusinessDay(LocalDate date) {
        return !this.isHoliday(date);
    }

    default public LocalDate shift(LocalDate date, int numberOfDays) {
        LocalDate shifted;
        block3: {
            block2: {
                shifted = date;
                if (numberOfDays <= 0) break block2;
                for (int i = 0; i < numberOfDays; ++i) {
                    shifted = this.next(shifted);
                }
                break block3;
            }
            if (numberOfDays >= 0) break block3;
            for (int i = 0; i > numberOfDays; --i) {
                shifted = this.previous(shifted);
            }
        }
        return shifted;
    }

    default public LocalDate previous(LocalDate date) {
        return this.previousOrSame(date.minusDays(1L));
    }

    default public LocalDate previousOrSame(LocalDate date) {
        int c = 0;
        LocalDate previous = date;
        while (this.isHoliday(previous)) {
            previous = previous.minusDays(1L);
            if (++c < 3650) continue;
            throw new DateCalculationException("no business day found within the previous 3650 days");
        }
        return previous;
    }

    default public LocalDate next(LocalDate date) {
        return this.nextOrSame(date.plusDays(1L));
    }

    default public LocalDate nextOrSame(LocalDate date) {
        int c = 0;
        LocalDate next = date;
        while (this.isHoliday(next)) {
            next = next.plusDays(1L);
            if (++c < 3650) continue;
            throw new DateCalculationException("no business day found within the next 3650 days");
        }
        return next;
    }

    default public List<LocalDate> holidaysWithin(LocalDate from, LocalDate to) {
        if (from.isAfter(to)) {
            throw new IllegalArgumentException("from is after to");
        }
        ArrayList<LocalDate> occurrences = new ArrayList<LocalDate>(0);
        LocalDate date = from;
        while (date.isBefore(to.plusDays(1L))) {
            if (this.isHoliday(date)) {
                occurrences.add(date);
            }
            date = date.plusDays(1L);
        }
        return Collections.unmodifiableList(occurrences);
    }

    default public List<LocalDate> businessDaysWithin(LocalDate from, LocalDate to) {
        if (from.isAfter(to)) {
            throw new IllegalArgumentException("from is after to");
        }
        ArrayList<LocalDate> occurrences = new ArrayList<LocalDate>(0);
        LocalDate date = from;
        while (date.isBefore(to.plusDays(1L))) {
            if (this.isBusinessDay(date)) {
                occurrences.add(date);
            }
            date = date.plusDays(1L);
        }
        return Collections.unmodifiableList(occurrences);
    }
}

