/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.gson;

import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class MultimapAdapterSupport<M extends Multimap>
implements JsonDeserializer<M>,
JsonSerializer<M> {
    static <K, V> TypeToken<Map<K, Collection<V>>> multimapOf(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Map<K, Collection<V>>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    protected abstract M createMultimap();

    public M deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Type keyType = actualTypeArguments[0];
        Type valueType = actualTypeArguments[1];
        Type type2 = MultimapAdapterSupport.multimapOf(TypeToken.of((Type)keyType), TypeToken.of((Type)valueType)).getType();
        Map map = (Map)context.deserialize(json, type2);
        M result = this.createMultimap();
        for (Object key : map.keySet()) {
            List multimapValues = (List)map.get(key);
            result.putAll(key, (Iterable)multimapValues);
        }
        return result;
    }

    public JsonElement serialize(M src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src.asMap());
    }
}

