/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.gson;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.ird.observe.gson.MultimapAdapterSupport;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ImmutableMultimapAdapter
implements JsonSerializer<ImmutableMultimap>,
JsonDeserializer<ImmutableMultimap> {
    public JsonElement serialize(ImmutableMultimap src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src.asMap());
    }

    public ImmutableMultimap deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Type keyType = actualTypeArguments[0];
        Type valueType = actualTypeArguments[1];
        Type type2 = MultimapAdapterSupport.multimapOf(TypeToken.of((Type)keyType), TypeToken.of((Type)valueType)).getType();
        Map map = (Map)context.deserialize(json, type2);
        for (Object key : map.keySet()) {
            List multimapValues = (List)map.get(key);
            for (Object multimapValue : multimapValues) {
                builder.put(key, multimapValue);
            }
        }
        return builder.build();
    }
}

