/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.gson;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.ird.observe.dto.form.Form;
import fr.ird.observe.dto.reference.DataDtoReferenceSet;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceSet;
import fr.ird.observe.gson.ArrayListMultimapAdapter;
import fr.ird.observe.gson.ClassAdapter;
import fr.ird.observe.gson.DateAdapter;
import fr.ird.observe.gson.DtoModelNavigationAggregateModelAdapter;
import fr.ird.observe.gson.DtoModelNavigationModelAdapter;
import fr.ird.observe.gson.FormAdapter;
import fr.ird.observe.gson.ImmutableListAdapter;
import fr.ird.observe.gson.ImmutableMapAdapter;
import fr.ird.observe.gson.ImmutableMultimapAdapter;
import fr.ird.observe.gson.ImmutableSetAdapter;
import fr.ird.observe.gson.ImmutableSetDtoMapAdapter;
import fr.ird.observe.gson.ImmutableSetStringMapAdapter;
import fr.ird.observe.gson.IntegerAdapter;
import fr.ird.observe.gson.SetMultimapAdapter;
import fr.ird.observe.gson.VersionAdapter;
import fr.ird.observe.gson.reference.DataReferenceSetAdapter;
import fr.ird.observe.gson.reference.ReferentialReferenceSetAdapter;
import fr.ird.observe.navigation.model.DtoModelNavigationAggregateModel;
import fr.ird.observe.navigation.model.DtoModelNavigationModel;
import fr.ird.observe.spi.map.ImmutableSetDtoMap;
import fr.ird.observe.spi.map.ImmutableSetStringMap;
import io.ultreia.java4all.util.ServiceLoaders;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.function.Supplier;
import org.nuiton.version.Version;

public class DtoGsonSupplierSupport
implements Supplier<Gson> {
    private final boolean prettyPrint;
    protected GsonBuilder gsonBuilder;
    private Gson gson;

    public DtoGsonSupplierSupport(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public Gson get() {
        if (this.gson == null) {
            this.gson = this.getGsonBuilder(this.prettyPrint).create();
        }
        return this.gson;
    }

    protected GsonBuilder getGsonBuilder(boolean prettyPrint) {
        if (this.gsonBuilder == null) {
            this.gsonBuilder = new GsonBuilder();
            if (prettyPrint) {
                this.gsonBuilder.setPrettyPrinting();
            }
            this.gsonBuilder.registerTypeAdapter(Class.class, (Object)new ClassAdapter());
            DtoModelNavigationModelAdapter dtoModelNavigationModelAdapter = new DtoModelNavigationModelAdapter();
            DtoModelNavigationAggregateModelAdapter dtoModelNavigationAggregateModelAdapter = new DtoModelNavigationAggregateModelAdapter();
            for (Class model : ServiceLoaders.loadTypes(DtoModelNavigationModel.class)) {
                this.gsonBuilder.registerTypeAdapter((Type)model, (Object)dtoModelNavigationModelAdapter);
            }
            for (Class model : ServiceLoaders.loadTypes(DtoModelNavigationAggregateModel.class)) {
                this.gsonBuilder.registerTypeAdapter((Type)model, (Object)dtoModelNavigationAggregateModelAdapter);
            }
            this.gsonBuilder.registerTypeAdapter(Integer.class, (Object)new IntegerAdapter());
            this.gsonBuilder.registerTypeAdapter(java.util.Date.class, (Object)new DateAdapter());
            this.gsonBuilder.registerTypeAdapter(Timestamp.class, (Object)new DateAdapter());
            this.gsonBuilder.registerTypeAdapter(Time.class, (Object)new DateAdapter());
            this.gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateAdapter());
            this.gsonBuilder.registerTypeAdapter(Class.class, (Object)new ClassAdapter());
            this.gsonBuilder.registerTypeAdapter(ImmutableList.class, (Object)new ImmutableListAdapter());
            this.gsonBuilder.registerTypeAdapter(ImmutableSet.class, (Object)new ImmutableSetAdapter());
            this.gsonBuilder.registerTypeAdapter(ImmutableMap.class, (Object)new ImmutableMapAdapter());
            this.gsonBuilder.registerTypeAdapter(ImmutableMultimap.class, (Object)new ImmutableMultimapAdapter());
            this.gsonBuilder.registerTypeAdapter(SetMultimap.class, (Object)new SetMultimapAdapter());
            this.gsonBuilder.registerTypeAdapter(ArrayListMultimap.class, (Object)new ArrayListMultimapAdapter());
            this.gsonBuilder.registerTypeAdapter(ImmutableSetDtoMap.class, (Object)new ImmutableSetDtoMapAdapter());
            this.gsonBuilder.registerTypeAdapter(ImmutableSetStringMap.class, (Object)new ImmutableSetStringMapAdapter());
            this.gsonBuilder.registerTypeAdapter(DataDtoReferenceSet.class, new DataReferenceSetAdapter());
            this.gsonBuilder.registerTypeAdapter(ReferentialDtoReferenceSet.class, new ReferentialReferenceSetAdapter());
            this.gsonBuilder.registerTypeAdapter(Form.class, new FormAdapter());
            this.gsonBuilder.registerTypeAdapter(Version.class, (Object)new VersionAdapter());
            this.gsonBuilder.enableComplexMapKeySerialization();
        }
        return this.gsonBuilder;
    }
}

