/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.reference;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.ObserveDto;
import fr.ird.observe.dto.reference.DtoReferenceAware;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class DtoReference<D extends IdDto, R extends DtoReference<D, R>>
extends IdDto
implements ObserveDto,
DtoReferenceAware {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_CREATE_DATE = "createDate";
    public static final String PROPERTY_VERSION = "version";

    public abstract DtoReferenceDefinition<D, R> getDefinition();

    protected DtoReference(DtoReferenceAware dto) {
        Objects.requireNonNull(dto);
        this.id = dto.getTopiaId();
        this.version = dto.getTopiaVersion();
        this.createDate = dto.getTopiaCreateDate();
        this.lastUpdateDate = dto.getLastUpdateDate();
    }

    public static <BeanType extends DtoReference> Predicate<BeanType> newIdPredicate(String id) {
        return input -> Objects.equals(id, input.getId());
    }

    public static <BeanType extends DtoReference> Map<String, BeanType> splitById(Collection<BeanType> dtos) {
        return Maps.uniqueIndex(dtos, IdDto::getId);
    }

    public static <BeanType extends DtoReference> Collection<BeanType> filterById(Collection<BeanType> source, String id) {
        return source.stream().filter(DtoReference.newIdPredicate(id)).collect(Collectors.toList());
    }

    public static <BeanType extends DtoReference> BeanType find(Collection<BeanType> source, String id) {
        return (BeanType)((DtoReference)source.stream().filter(DtoReference.newIdPredicate(id)).findFirst().orElse(null));
    }

    @Override
    public final Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public final long getVersion() {
        return this.version;
    }

    public <O> O getPropertyValue(String propertyName) {
        Function propertyFunction = this.getDefinition().getPropertyFunction(propertyName);
        return propertyFunction.apply(this);
    }

    public Class<D> getDtoType() {
        return this.getDefinition().getDtoType();
    }

    public Class<R> getReferenceType() {
        return this.getDefinition().getType();
    }

    public ImmutableSet<String> getPropertyNames() {
        return this.getDefinition().getPropertyNames();
    }
}

