/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.navigation.tree;

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.navigation.tree.ReferenceNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public interface MultipleReferenceContainerNode<D extends IdDto, R extends DtoReference<D, R>>
extends MutableTreeNode {
    public static <D extends IdDto, R extends DtoReference<D, R>> MultipleReferenceContainerNode<D, R> upToReferenceContainerNode(Class<R> referenceType, MutableTreeNode node) {
        for (MutableTreeNode result = Objects.requireNonNull(node); result != null; result = (MutableTreeNode)result.getParent()) {
            MultipleReferenceContainerNode referenceNode;
            if (!(result instanceof MultipleReferenceContainerNode) || !(referenceNode = (MultipleReferenceContainerNode)result).getChildrenReferenceType().equals(referenceType)) continue;
            return referenceNode;
        }
        throw new IllegalStateException("Can't go up reference container node of type: " + referenceType.getName() + " from node: " + node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> MultipleReferenceContainerNode<D, R> downToReferenceContainerNode(Class<R> referenceType, MutableTreeNode node) {
        MultipleReferenceContainerNode referenceContainerNode;
        if (node instanceof MultipleReferenceContainerNode && (referenceContainerNode = (MultipleReferenceContainerNode)node).getChildrenReferenceType().equals(referenceType)) {
            return referenceContainerNode;
        }
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            MultipleReferenceContainerNode referenceContainerNode2;
            MutableTreeNode childrenNode = (MutableTreeNode)children.nextElement();
            if (!(childrenNode instanceof MultipleReferenceContainerNode) || !(referenceContainerNode2 = (MultipleReferenceContainerNode)childrenNode).getChildrenReferenceType().equals(referenceType)) continue;
            return referenceContainerNode2;
        }
        throw new IllegalStateException("Can't go down to reference container node of type: " + referenceType.getName() + " from node: " + node);
    }

    public Class<D> getChildrenDtoType();

    public Class<R> getChildrenReferenceType();

    default public List<ReferenceNode<D, R>> getChildrenReferenceNodes() {
        Enumeration<? extends TreeNode> children = this.children();
        Class<R> childrenReferenceType = this.getChildrenReferenceType();
        LinkedList<ReferenceNode<D, R>> result = new LinkedList<ReferenceNode<D, R>>();
        while (children.hasMoreElements()) {
            ReferenceNode referenceNode;
            MutableTreeNode o = (MutableTreeNode)children.nextElement();
            if (!(o instanceof ReferenceNode) || !childrenReferenceType.isAssignableFrom((referenceNode = (ReferenceNode)o).getReferenceReferenceType())) continue;
            result.add(referenceNode);
        }
        return result;
    }

    default public ReferenceNode<D, R> getChildrenReferenceNode(String id) {
        Enumeration<? extends TreeNode> children = this.children();
        Class<R> childrenReferenceType = this.getChildrenReferenceType();
        while (children.hasMoreElements()) {
            ReferenceNode referenceNode;
            MutableTreeNode o = (MutableTreeNode)children.nextElement();
            if (!(o instanceof ReferenceNode) || !childrenReferenceType.isAssignableFrom((referenceNode = (ReferenceNode)o).getReferenceReferenceType()) || !((IdDto)referenceNode.getReference()).getId().equals(id)) continue;
            return referenceNode;
        }
        return null;
    }

    default public List<R> getChildrenReferences() {
        Enumeration<? extends TreeNode> children = this.children();
        Class<R> childrenReferenceType = this.getChildrenReferenceType();
        LinkedList result = new LinkedList();
        while (children.hasMoreElements()) {
            ReferenceNode referenceNode;
            MutableTreeNode o = (MutableTreeNode)children.nextElement();
            if (!(o instanceof ReferenceNode) || !childrenReferenceType.isAssignableFrom((referenceNode = (ReferenceNode)o).getReferenceReferenceType())) continue;
            result.add(referenceNode.getReference());
        }
        return result;
    }

    public Comparator<R> getChildrenComparator();

    default public int getNodePosition(R reference) {
        return this.getChildrenPosition(reference);
    }

    default public int getChildrenPosition(R reference) {
        LinkedHashSet<R> childrenReferences = new LinkedHashSet<R>(this.getChildrenReferences());
        childrenReferences.remove(reference);
        childrenReferences.add(reference);
        ArrayList<R> list = new ArrayList<R>(childrenReferences);
        list.sort(this.getChildrenComparator());
        return list.indexOf(reference);
    }

    public ReferenceNode<D, R> newChildNode(R var1);

    public ReferenceNode<D, R> newChildNode(String var1);

    public TreeNode[] getPath();
}

