/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.gson;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.ird.observe.dto.navigation.DtoModelNavigationModel;
import fr.ird.observe.dto.navigation.DtoModelNavigationNode;
import io.ultreia.java4all.lang.Objects2;
import java.lang.reflect.Type;
import java.util.Map;

public class DtoModelNavigationModelAdapter
implements JsonSerializer<DtoModelNavigationModel<?>>,
JsonDeserializer<DtoModelNavigationModel<?>> {
    public JsonElement serialize(DtoModelNavigationModel<?> src, Type typeOfSrc, JsonSerializationContext context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DtoModelNavigationNode node : src.getNodesWithIds()) {
            builder.put(node.getClass(), (Object)node.getId());
        }
        return context.serialize((Object)new DtoModelNavigationModelStr(src.getClass(), (ImmutableMap<Class<? extends DtoModelNavigationNode>, String>)builder.build()));
    }

    public DtoModelNavigationModel deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        DtoModelNavigationModelStr deserialize = (DtoModelNavigationModelStr)context.deserialize(json, DtoModelNavigationModelStr.class);
        Class<? extends DtoModelNavigationModel> modelType = deserialize.getType();
        DtoModelNavigationModel result = (DtoModelNavigationModel)Objects2.newInstance(modelType);
        for (Map.Entry entry : deserialize.getIds().entrySet()) {
            Object model = result.getNode((Class)entry.getKey());
            model.setId((String)entry.getValue());
        }
        return result;
    }

    static class DtoModelNavigationModelStr {
        private final Class<? extends DtoModelNavigationModel> type;
        private final ImmutableMap<Class<? extends DtoModelNavigationNode>, String> ids;

        DtoModelNavigationModelStr(Class<? extends DtoModelNavigationModel> type, ImmutableMap<Class<? extends DtoModelNavigationNode>, String> ids) {
            this.type = type;
            this.ids = ids;
        }

        public Class<? extends DtoModelNavigationModel> getType() {
            return this.type;
        }

        public ImmutableMap<Class<? extends DtoModelNavigationNode>, String> getIds() {
            return this.ids;
        }
    }
}

