/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Base64;
import javax.sql.rowset.serial.SerialBlob;

public class BlobAdapter
implements JsonSerializer<Blob>,
JsonDeserializer<Blob> {
    public Blob deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String blob64 = json.getAsString();
        byte[] bytes = Base64.getDecoder().decode(blob64);
        try {
            return new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new JsonParseException("could not create blob ", (Throwable)e);
        }
    }

    public JsonElement serialize(Blob src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            byte[] bytes = src.getBytes(1L, (int)src.length());
            Base64.Encoder encoder = Base64.getEncoder();
            String blob64 = encoder.encodeToString(bytes);
            return new JsonPrimitive(blob64);
        }
        catch (SQLException e) {
            throw new JsonParseException("could not read blob ", (Throwable)e);
        }
    }
}

