/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.navigation;

import com.google.common.collect.ImmutableList;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.navigation.DtoModelNavigationNode;
import io.ultreia.java4all.bean.JavaBean;

public interface DtoModelNavigationModel<N extends DtoModelNavigationNode>
extends JavaBean {
    public static final String PROPERTY_ENABLED = "enabled";

    public boolean accept(IdDto var1);

    public <D extends DtoModelNavigationNode> D getNode(Class<D> var1);

    public N getRoot();

    public ImmutableList<N> getNodes();

    public ImmutableList<N> getNodesWithIds();

    default public boolean isEnabled() {
        return this.getRoot().isEnabled();
    }

    default public boolean isDisabled() {
        return !this.isEnabled();
    }

    default public void load(DtoModelNavigationModel<?> model) {
        for (DtoModelNavigationNode n : model.getNodesWithIds()) {
            this.getNode(n.getClass()).setId(n.getId());
        }
    }

    default public int count() {
        return (int)this.getNodes().stream().filter(DtoModelNavigationNode::isEnabled).count();
    }

    default public void clearModel() {
        this.getNodes().forEach(n -> n.setId(null));
    }
}

