/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.model;

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.model.DtoModel;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.DtoModelHelper;
import java.util.ServiceLoader;

public abstract class AggregateDtoModel
implements DtoModel {
    private static AggregateDtoModel instance;
    private final String name;
    private final ImmutableSet<DtoModel> models;
    private final ImmutableSet<Class<? extends ReferentialDto>> referentialTypes;
    private final ImmutableSet<Class<? extends DataDto>> dataTypes;

    protected AggregateDtoModel(String name) {
        this.name = name;
        ImmutableSet.Builder modelsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder referentialTypes = ImmutableSet.builder();
        ImmutableSet.Builder dataTypes = ImmutableSet.builder();
        for (DtoModel dtoModel : ServiceLoader.load(DtoModel.class)) {
            modelsBuilder.add((Object)dtoModel);
            referentialTypes.addAll(dtoModel.getReferentialTypes());
            dataTypes.addAll(dtoModel.getDataTypes());
        }
        this.referentialTypes = referentialTypes.build();
        this.dataTypes = dataTypes.build();
        this.models = modelsBuilder.build();
    }

    public static synchronized AggregateDtoModel get() {
        return instance == null ? (instance = DtoModelHelper.getService(AggregateDtoModel.class)) : instance;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableSet<Class<? extends ReferentialDto>> getReferentialTypes() {
        return this.referentialTypes;
    }

    @Override
    public ImmutableSet<Class<? extends DataDto>> getDataTypes() {
        return this.dataTypes;
    }

    public ImmutableSet<DtoModel> getModels() {
        return this.models;
    }
}

