/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto;

import fr.ird.observe.dto.IdDto;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class IdHelper {
    private static final String DTO_ROOT_PACKAGE = "fr.ird.observe.dto";
    private static final int DTO_ROOT_PACKAGE_LENGTH = "fr.ird.observe.dto".length() + 1;
    private static final String DTO_REFERENTIAL_PACKAGE = "fr.ird.observe.dto.referential";
    private static final String DTO_DATA_PACKAGE = "fr.ird.observe.dto.data";
    private static final String ENTITY_ROOT_PACKAGE = "fr.ird.observe.entities";
    private static final int ENTITY_ROOT_PACKAGE_LENGTH = "fr.ird.observe.entities".length() + 1;

    public static boolean isReferential(Class type) {
        return IdHelper.isReferentialFromPackageName(type.getPackage().getName());
    }

    public static boolean isReferentialFromPackageName(String packageName) {
        return packageName.startsWith(DTO_REFERENTIAL_PACKAGE);
    }

    public static boolean isData(Class type) {
        return IdHelper.isDataFromPackageName(type.getPackage().getName());
    }

    private static boolean isDataFromPackageName(String packageName) {
        return packageName.startsWith(DTO_DATA_PACKAGE);
    }

    public static String getDtoSimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType.getName().substring(DTO_ROOT_PACKAGE_LENGTH));
    }

    public static String getEntitySimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType.getName().substring(ENTITY_ROOT_PACKAGE_LENGTH));
    }

    public static String getEntityShortName(String id) {
        String simplifiedName = IdHelper.getEntitySimplifiedName(id);
        int i = simplifiedName.indexOf("#");
        int j = (simplifiedName = simplifiedName.substring(0, i)).lastIndexOf(".");
        return j == -1 ? simplifiedName : simplifiedName.substring(j + 1);
    }

    public static String getEntitySimplifiedName(String dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType.substring(ENTITY_ROOT_PACKAGE_LENGTH));
    }

    public static String getDtoShortName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return IdHelper.cleanId(dataType);
    }

    public static String cleanId(Class id) {
        return IdHelper.cleanId(id.getSimpleName());
    }

    public static boolean equalsCleanId(Class one, Class two) {
        return IdHelper.cleanId(one.getSimpleName()).equals(IdHelper.cleanId(two.getSimpleName()));
    }

    public static String cleanId(String id) {
        if (id.endsWith("Dto")) {
            return id.substring(0, id.length() - 3);
        }
        if (id.endsWith("Reference")) {
            return id.substring(0, id.length() - 9);
        }
        int index = id.indexOf("_");
        if (index > -1) {
            id = id.substring(0, index);
        } else {
            index = id.indexOf("@");
            if (index > -1) {
                id = id.substring(0, index);
            }
        }
        if (id.endsWith("Impl")) {
            return id.substring(0, id.length() - 4);
        }
        return id;
    }

    public static <BeanType extends IdDto> BeanType findById(Collection<BeanType> source, String id) {
        return (BeanType)((IdDto)source.stream().filter(IdHelper.newIdPredicate(id)::test).findFirst().orElse(null));
    }

    public static <BeanType extends IdDto> boolean exists(Collection<BeanType> source, String id) {
        return source.stream().anyMatch(IdHelper.newIdPredicate(id)::test);
    }

    public static <BeanType extends IdDto> Predicate<BeanType> newIdPredicate(String id) {
        return o -> Objects.equals(id, o.getId());
    }
}

