/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.type;

import fr.ird.observe.spi.type.TypeTranslator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;

public class TypeTranslators {
    private static TypeTranslators INSTANCE;
    private Set<TypeTranslator> translators;

    public static TypeTranslators get() {
        return INSTANCE == null ? (INSTANCE = new TypeTranslators()) : INSTANCE;
    }

    public static String getDtoSimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return TypeTranslators.getTranslator(dataType).cleanType(dataType);
    }

    public static String getEntitySimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return TypeTranslators.getTranslator(dataType).cleanType(dataType);
    }

    private Set<TypeTranslator> getTranslators() {
        if (this.translators == null) {
            this.translators = new LinkedHashSet<TypeTranslator>();
            for (TypeTranslator typeTranslator : ServiceLoader.load(TypeTranslator.class)) {
                this.translators.add(typeTranslator);
            }
        }
        return this.translators;
    }

    public static TypeTranslator getTranslator(Class<?> type) {
        return TypeTranslators.optionalTranslator(type).orElseThrow(() -> new IllegalStateException("Can't type type translator for type: " + type));
    }

    private static Optional<TypeTranslator> optionalTranslator(Class<?> type) {
        return TypeTranslators.get().getTranslators().stream().filter(t -> t.acceptType(type)).findFirst();
    }
}

