/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.type;

import fr.ird.observe.spi.type.TypeTranslator;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class TypeTranslatorSupport
implements TypeTranslator {
    private final String rootPackage;
    private final Class<?> type;
    private final List<String> suffixes;

    protected TypeTranslatorSupport(String rootPackage, Class<?> type, String ... suffixes) {
        this.rootPackage = rootPackage;
        this.type = type;
        this.suffixes = Arrays.asList(suffixes);
    }

    @Override
    public boolean acceptType(Class<?> type) {
        return this.type.isAssignableFrom(type) && type.getPackage().getName().startsWith(this.rootPackage);
    }

    @Override
    public String cleanType(Class<?> type) {
        return this.cleanType(type.getName());
    }

    @Override
    public String cleanType(String fqn) {
        int lastIndex = fqn.lastIndexOf(46);
        return StringUtils.removeStart((String)fqn.substring(0, lastIndex), (String)(this.rootPackage + ".")) + "." + this.cleanSimpleName(fqn.substring(lastIndex + 1));
    }

    @Override
    public String cleanSimpleName(String simpleName) {
        for (String suffix : this.suffixes) {
            simpleName = StringUtils.removeEnd((String)simpleName, (String)suffix);
        }
        return simpleName;
    }
}

