/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.spi.type.TypeTranslators;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ImmutableTypedMap<V> {
    private final ImmutableMap<String, V> data;
    private final ImmutableMap<String, Class> types;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    protected ImmutableTypedMap(ImmutableTypedMap<V> dtoMap) {
        this.data = dtoMap.data;
        this.types = dtoMap.types;
    }

    protected ImmutableTypedMap(ImmutableMap<String, V> data, ImmutableMap<String, Class> types) {
        this.data = data;
        this.types = types;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public V get(Class key) {
        return (V)this.data.get((Object)ImmutableTypedMap.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<V> values() {
        return this.data.values();
    }

    public Collection<Class<?>> types() {
        return this.types.values();
    }

    private static String key0(Class type) {
        return TypeTranslators.getTranslator(type).cleanType(type);
    }

    public static class Builder<V> {
        private final Map<String, V> data = new LinkedHashMap<String, V>();
        private final Map<String, Class> types = new LinkedHashMap<String, Class>();

        private Builder() {
        }

        public Builder put(Class type, V value) {
            String key = ImmutableTypedMap.key0(type);
            this.data.put(key, value);
            this.types.put(key, type);
            return this;
        }

        public ImmutableTypedMap<V> build() {
            return new ImmutableTypedMap(ImmutableMap.copyOf(this.data), (ImmutableMap<String, Class>)ImmutableMap.copyOf(this.types));
        }

        public V get(Class<?> type) {
            return this.data.get(type);
        }
    }
}

