/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.ObserveDto;
import fr.ird.observe.spi.type.TypeTranslators;
import java.util.Collection;
import java.util.Set;

public abstract class ImmutableSetMap<V>
implements ObserveDto {
    private final ImmutableMap<String, Set<V>> data;
    private final ImmutableMap<String, Class> types;

    ImmutableSetMap(ImmutableMap<String, Set<V>> data, ImmutableMap<String, Class> types) {
        this.data = data;
        this.types = types;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Set<V> get(Class key) {
        return (Set)this.data.get((Object)ImmutableSetMap.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<Set<V>> values() {
        return this.data.values();
    }

    public boolean containsEntry(Class type, V value) {
        String key = ImmutableSetMap.key0(type);
        return this.data.containsKey((Object)key) && ((Set)this.data.get((Object)key)).contains(value);
    }

    public ImmutableMap<String, Set<V>> getData() {
        return this.data;
    }

    public ImmutableMap<String, Class> getTypes() {
        return this.types;
    }

    public Collection<Class<?>> types() {
        return this.types.values();
    }

    protected static String key0(Class type) {
        return TypeTranslators.getTranslator(type).cleanType(type);
    }
}

