/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.map.ImmutableTypedMap;
import java.util.Collection;

public class DtoToReferenceClassMap {
    private final ImmutableTypedMap<Class> dtoMap;

    public DtoToReferenceClassMap(ImmutableTypedMap<Class> dtoMap) {
        this.dtoMap = dtoMap;
    }

    public <D extends DataDto, R extends DataDtoReference<D, R>> Class<R> forData(Class<D> key) {
        return this.get0(key);
    }

    public <D extends DataDto, R extends DataDtoReference<D, R>> Class<R> forData(D key) {
        return this.get0(key.getClass());
    }

    public <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> Class<R> forReferential(Class<D> key) {
        return this.get0(key);
    }

    public <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> Class<R> forReferential(D key) {
        return this.get0(key.getClass());
    }

    private <D extends IdDto, R extends DtoReference<D, R>> Class<R> get0(Class key) {
        return this.dtoMap.get(key);
    }

    public Collection<Class> values() {
        return this.dtoMap.values();
    }

    public int size() {
        return this.dtoMap.size();
    }
}

