/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.initializer;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.form.FormDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;
import fr.ird.observe.spi.map.DtoToDtoClassMap;
import fr.ird.observe.spi.map.ImmutableTypedMap;

public abstract class DtoFormsInitializerSupport {
    private final ImmutableMap.Builder<Class, Class> dtoToFormClassMappingBuilder = ImmutableMap.builder();
    protected final ImmutableTypedMap.Builder<FormDefinition<? extends IdDto>> formDefinitionsBuilder = ImmutableTypedMap.builder();
    private ImmutableTypedMap<FormDefinition<? extends IdDto>> formDefinitions;
    private DtoToDtoClassMap dtoToFormClassMapping;
    private final DtoReferencesInitializerSupport referencesInitializer;

    protected DtoFormsInitializerSupport(DtoReferencesInitializerSupport referencesInitializer) {
        this.referencesInitializer = referencesInitializer;
    }

    protected <D extends IdDto> FormDefinition.Builder<D> formBuilder(Class<D> type) {
        return new FormDefinition.Builder<D>(type);
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> FormDefinition.Builder<D> referentialFormBuilder(Class<D> dtoType) {
        Class referenceType = this.referencesInitializer.getDtoToReferenceClassMapping().forReferential(dtoType);
        FormDefinition.Builder<D> dBuilder = new FormDefinition.Builder<D>(dtoType);
        return dBuilder.addProperty("referentialListHeader", referenceType);
    }

    protected <D extends IdDto, F extends IdDto> void addClassMapping(Class<D> dtoType, Class<F> formType) {
        this.dtoToFormClassMappingBuilder.put(dtoType, formType);
    }

    public void end() {
        this.dtoToFormClassMapping = new DtoToDtoClassMap((ImmutableMap<Class, Class>)this.dtoToFormClassMappingBuilder.build());
        this.formDefinitions = this.formDefinitionsBuilder.build();
    }

    public ImmutableTypedMap<FormDefinition<? extends IdDto>> getFormDefinitions() {
        return this.formDefinitions;
    }

    public DtoToDtoClassMap getDtoToFormClassMapping() {
        return this.dtoToFormClassMapping;
    }
}

