/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.context;

import fr.ird.observe.binder.referential.ReferentialDtoReferenceBinder;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceDefinition;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.context.ReferenceContext;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;

public class ReferentialReferenceContext<D extends ReferentialDto, R extends ReferentialDtoReference<D, R>>
implements ReferenceContext<D, R> {
    private final Class<R> referenceType;
    private final Class<D> dtoType;
    private final ReferentialDtoReferenceBinder<D, R> referenceBinder;
    private final ReferentialDtoReferenceDefinition<D, R> referenceDefinition;

    ReferentialReferenceContext(Class<R> referenceType, DtoReferencesInitializerSupport modelHelper) {
        this.referenceType = referenceType;
        this.dtoType = modelHelper.getReferenceToDtoClassMapping().forReferential(referenceType);
        this.referenceBinder = modelHelper.getReferentialBinders().get(referenceType);
        this.referenceDefinition = modelHelper.getReferentialReferenceSetDefinition().get(referenceType);
    }

    @Override
    public Class<D> toDtoType() {
        return this.dtoType;
    }

    @Override
    public ReferentialDtoReferenceBinder<D, R> toReferenceBinder() {
        return this.referenceBinder;
    }

    @Override
    public DtoReferenceDefinition<D, R> toReferenceDefinition() {
        return this.referenceDefinition;
    }

    @Override
    public Class<R> toReferenceType() {
        return this.referenceType;
    }
}

