/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi;

import org.apache.commons.lang3.StringUtils;

public interface ProjectPackagesDefinition {
    public String getDtoRootPackage();

    public String getDtoReferentialPackage();

    public String getDtoDataPackage();

    public String getEntityRootPackage();

    public String getEntityReferentialPackage();

    public String getEntityDataPackage();

    default public boolean isReferential(Class type) {
        return this.isReferentialFromPackageName(type.getPackage().getName());
    }

    default public boolean isReferentialFromPackageName(String packageName) {
        return packageName.startsWith(this.getDtoReferentialPackage());
    }

    default public boolean isData(Class type) {
        return this.isDataFromPackageName(type.getPackage().getName());
    }

    default public boolean isDataFromPackageName(String packageName) {
        return packageName.startsWith(this.getDtoDataPackage());
    }

    default public String getRelativeDtoPackage(String dtoClassName) {
        return StringUtils.removeStart((String)dtoClassName, (String)this.getDtoRootPackage());
    }

    default public String getRelativeEntityPackage(String dtoClassName) {
        return StringUtils.removeStart((String)dtoClassName, (String)this.getEntityRootPackage());
    }

    public static String cleanType(String fqn) {
        if (fqn.endsWith("Dto")) {
            return fqn.substring(0, fqn.length() - 3);
        }
        if (fqn.endsWith("Reference")) {
            return fqn.substring(0, fqn.length() - 9);
        }
        int index = fqn.indexOf("_");
        if (index > -1) {
            fqn = fqn.substring(0, index);
        } else {
            index = fqn.indexOf("@");
            if (index > -1) {
                fqn = fqn.substring(0, index);
            }
        }
        if (fqn.endsWith("Impl")) {
            return fqn.substring(0, fqn.length() - 4);
        }
        return fqn;
    }
}

