/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi;

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.form.FormDefinition;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.dto.referential.ReferentialLocale;
import fr.ird.observe.spi.DtoModelHelperApplicationComponent;
import fr.ird.observe.spi.context.DataDtoContext;
import fr.ird.observe.spi.context.DataFormContext;
import fr.ird.observe.spi.context.DtoContext;
import fr.ird.observe.spi.context.ReferentialDtoContext;
import fr.ird.observe.spi.context.ReferentialFormContext;
import fr.ird.observe.spi.initializer.DtoFormsInitializerSupport;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;
import fr.ird.observe.spi.initializer.DtoToMainDtoInitializerSupport;
import fr.ird.observe.spi.map.DtoToDtoClassMap;
import fr.ird.observe.spi.map.ImmutableTypedMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtoModelHelper {
    private static final Logger log = LogManager.getLogger(DtoModelHelper.class);
    private static final DtoModelHelper INSTANCE = DtoModelHelperApplicationComponent.value();
    private final DtoReferencesInitializerSupport referencesInitializer;
    private final ImmutableTypedMap<ReferentialDtoContext> referentialDtoContext;
    private final ImmutableTypedMap<ReferentialFormContext> referentialFormContext;
    private final ImmutableTypedMap<DataDtoContext> dataDtoContext;
    private final ImmutableTypedMap<DataFormContext> dataFormContext;
    private final ImmutableSet<Class> referentialClasses;
    private final ImmutableSet<Class> mainDataClasses;
    private final DtoToDtoClassMap dtoToMainDtoClassMapping;

    public DtoModelHelper(DtoFormsInitializerSupport formInitializer, DtoReferencesInitializerSupport referencesInitializer, DtoToMainDtoInitializerSupport dtoToMainDtoInitializer) {
        this.referencesInitializer = referencesInitializer;
        log.info("Dto model helper initialization  (" + this + ").");
        ImmutableTypedMap.Builder<ReferentialDtoContext> referentialDtoContextBuilder = ImmutableTypedMap.builder();
        ImmutableTypedMap.Builder<ReferentialFormContext> referentialFormContextBuilder = ImmutableTypedMap.builder();
        ImmutableTypedMap.Builder<DataDtoContext> dataDtoContextBuilder = ImmutableTypedMap.builder();
        ImmutableTypedMap.Builder<DataFormContext> dataFormContextBuilder = ImmutableTypedMap.builder();
        LinkedHashSet<Class> mainDataClassesBuilder = new LinkedHashSet<Class>();
        LinkedHashSet<Class> referentialClassesBuilder = new LinkedHashSet<Class>();
        Collection<Class<? extends IdDto>> dtoTypesWithReference = this.referencesInitializer.getReferenceToDtoClassMapping().values();
        int referentialCount = 0;
        for (Class dtoType : this.referencesInitializer.getReferentialTypes()) {
            DtoModelHelper.registerReferential(dtoType, this.referencesInitializer, formInitializer, referentialDtoContextBuilder, referentialFormContextBuilder);
            referentialClassesBuilder.add(dtoType);
            ++referentialCount;
        }
        log.info("Load " + referentialCount + " referential definitions.");
        Set<Class> dtoTypesWithForm = formInitializer.getDtoToFormClassMapping().keys();
        int dataCountWithReference = 0;
        int dataCountWithForm = 0;
        LinkedHashSet<Class<? extends DataDto>> dataTypes = new LinkedHashSet<Class<? extends DataDto>>((Collection<Class<? extends DataDto>>)this.referencesInitializer.getDataTypes());
        dataTypes.addAll(dtoTypesWithForm);
        for (Class dtoType : dataTypes) {
            FormDefinition<? extends IdDto> formDefinition;
            Class formType = formInitializer.getDtoToFormClassMapping().forData(dtoType);
            if (dtoTypesWithForm.contains(formType) && (formDefinition = formInitializer.getFormDefinitions().get(formType)) != null) {
                DtoModelHelper.registerDataForm(dtoType, formType, formDefinition, dataFormContextBuilder);
                ++dataCountWithForm;
            }
            mainDataClassesBuilder.add(dtoType);
            if (this.referencesInitializer.getDtoToReferenceClassMapping().forData(dtoType) == null) continue;
            if (dtoTypesWithReference.contains(dtoType)) {
                DtoModelHelper.registerDataWithReference(dtoType, this.referencesInitializer, dataDtoContextBuilder);
                ++dataCountWithReference;
                continue;
            }
            DtoModelHelper.registerData(dtoType, this.referencesInitializer, dataDtoContextBuilder);
        }
        log.info("Load " + dataCountWithReference + " reference definitions.");
        log.info("Load " + dataCountWithForm + " form definitions.");
        log.info("Load " + this.referencesInitializer.getReferentialBinders().size() + " dto referential binders.");
        log.info("Load " + this.referencesInitializer.getDataBinders().size() + " dto data binders.");
        log.info("Load " + dtoToMainDtoInitializer.getDtoToMainDtoClassMapping().size() + " dto to main dto types.");
        this.referentialDtoContext = referentialDtoContextBuilder.build();
        this.referentialFormContext = referentialFormContextBuilder.build();
        this.referentialClasses = ImmutableSet.copyOf(referentialClassesBuilder);
        this.dataDtoContext = dataDtoContextBuilder.build();
        this.dataFormContext = dataFormContextBuilder.build();
        this.mainDataClasses = ImmutableSet.copyOf(mainDataClassesBuilder);
        this.dtoToMainDtoClassMapping = dtoToMainDtoInitializer.getDtoToMainDtoClassMapping();
        log.info("Dto model helper is initialized (" + this + ").");
    }

    public static Set<Class<? extends ReferentialDto>> getReferentialClasses() {
        return DtoModelHelper.INSTANCE.referentialClasses;
    }

    public static Set<Class<? extends DataDto>> getMainDataClasses() {
        return DtoModelHelper.INSTANCE.mainDataClasses;
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> DtoContext<D, R> fromDto(Class<D> dtoType) {
        if (DtoModelHelper.isReferential(dtoType)) {
            return DtoModelHelper.INSTANCE.referentialDtoContext.get(dtoType);
        }
        return DtoModelHelper.INSTANCE.dataDtoContext.get(dtoType);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> DtoContext<D, R> fromReference(Class<R> referenceType) {
        if (DtoModelHelper.isReferential(referenceType)) {
            Class dtoType = DtoModelHelper.INSTANCE.referencesInitializer.getReferenceToDtoClassMapping().forReferential(referenceType);
            return DtoModelHelper.INSTANCE.referentialDtoContext.get(dtoType);
        }
        Class dtoType = DtoModelHelper.INSTANCE.referencesInitializer.getReferenceToDtoClassMapping().forData(referenceType);
        return DtoModelHelper.INSTANCE.dataDtoContext.get(dtoType);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> Class<R> getReferenceType(Class<D> dtoType) {
        return DtoModelHelper.fromDto(dtoType).toReferenceType();
    }

    public static <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> ReferentialDtoContext<D, R> fromReferentialDto(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.referentialDtoContext.get(dtoType);
    }

    public static <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> ReferentialDtoContext<D, R> fromReferentialReference(Class<R> referenceType) {
        Class dtoType = DtoModelHelper.INSTANCE.referencesInitializer.getReferenceToDtoClassMapping().forReferential(referenceType);
        return DtoModelHelper.INSTANCE.referentialDtoContext.get(dtoType);
    }

    public static <D extends DataDto, R extends DataDtoReference<D, R>> DataDtoContext<D, R> fromDataReference(Class<R> referenceType) {
        Class dtoType = DtoModelHelper.INSTANCE.referencesInitializer.getReferenceToDtoClassMapping().forData(referenceType);
        return DtoModelHelper.INSTANCE.dataDtoContext.get(dtoType);
    }

    public static <D extends DataDto, R extends DataDtoReference<D, R>> DataDtoContext<D, R> fromDataDto(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.dataDtoContext.get(dtoType);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> R toReference(ReferentialLocale referentialLocale, D dto) {
        return DtoModelHelper.fromDto(dto.getClass()).toReference(referentialLocale, dto);
    }

    public static <D extends IdDto, S extends IdDto> Class<S> getMainDtoType(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.dtoToMainDtoClassMapping.forDto(dtoType);
    }

    public static <D extends IdDto> Optional<FormDefinition<D>> getOptionalFormDefinition(Class<? extends IdDto> dtoType) {
        if (DtoModelHelper.isReferential(dtoType)) {
            Optional optional = Optional.ofNullable(DtoModelHelper.fromReferentialForm(dtoType));
            return optional.map(ReferentialFormContext::toFormDefinition);
        }
        Optional optional = Optional.ofNullable(DtoModelHelper.fromDataForm(dtoType));
        return optional.map(DataFormContext::toFormDefinition);
    }

    static <D extends ReferentialDto, F extends ReferentialDto> ReferentialFormContext<D, F> fromReferentialForm(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.referentialFormContext.get(dtoType);
    }

    static <D extends DataDto, F extends DataDto> DataFormContext<D, F> fromDataForm(Class<D> dtoType) {
        return DtoModelHelper.INSTANCE.dataFormContext.get(dtoType);
    }

    private static <D extends ReferentialDto> void registerReferential(Class<D> dtoType, DtoReferencesInitializerSupport referencesInitializer, DtoFormsInitializerSupport formInitializer, ImmutableTypedMap.Builder<ReferentialDtoContext> referentialDtoContextBuilder, ImmutableTypedMap.Builder<ReferentialFormContext> referentialFormContextBuilder) {
        referentialDtoContextBuilder.put(dtoType, new ReferentialDtoContext(dtoType, referencesInitializer));
        referentialFormContextBuilder.put(dtoType, new ReferentialFormContext<D, IdDto>(dtoType, dtoType, formInitializer.getFormDefinitions().get(dtoType)));
    }

    private static <D extends DataDto> void registerData(Class<D> dtoType, DtoReferencesInitializerSupport referencesInitializer, ImmutableTypedMap.Builder<DataDtoContext> dataDtoContextBuilder) {
        dataDtoContextBuilder.put(dtoType, new DataDtoContext(dtoType, referencesInitializer));
    }

    private static <D extends DataDto, F extends DataDto> void registerDataForm(Class<D> dtoType, Class<F> formType, FormDefinition<F> referencesInitializer, ImmutableTypedMap.Builder<DataFormContext> dataFormContextBuilder) {
        dataFormContextBuilder.put(dtoType, new DataFormContext<D, F>(dtoType, formType, referencesInitializer));
    }

    private static <D extends DataDto> void registerDataWithReference(Class<D> dtoType, DtoReferencesInitializerSupport referencesInitializer, ImmutableTypedMap.Builder<DataDtoContext> dataDtoContextBuilder) {
        dataDtoContextBuilder.put(dtoType, new DataDtoContext(dtoType, referencesInitializer));
    }

    public static boolean isReferential(Class type) {
        return ReferentialDto.class.isAssignableFrom(type) || ReferentialDtoReference.class.isAssignableFrom(type);
    }

    public static boolean isData(Class type) {
        return DataDto.class.isAssignableFrom(type) || DataDtoReference.class.isAssignableFrom(type);
    }
}

