/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.navigation.tree;

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.navigation.tree.ReferenceNode;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public interface SingleReferenceContainerNode<D extends IdDto, R extends DtoReference<D, R>>
extends MutableTreeNode {
    public static <N extends SingleReferenceContainerNode<?, ?>> N up(Class<?> referenceType, MutableTreeNode node) {
        return (N)SingleReferenceContainerNode.upToSingleReferenceContainerNode(referenceType, node);
    }

    public static <N extends SingleReferenceContainerNode<?, ?>> N down(Class<?> referenceType, MutableTreeNode node) {
        return (N)SingleReferenceContainerNode.downToSingleReferenceContainerNode(referenceType, node);
    }

    public static SingleReferenceContainerNode<?, ?> upToSingleReferenceContainerNode(Class<?> referenceType, MutableTreeNode node) {
        for (MutableTreeNode result = Objects.requireNonNull(node); result != null; result = (MutableTreeNode)result.getParent()) {
            SingleReferenceContainerNode singleReferenceContainerNode;
            if (!(result instanceof SingleReferenceContainerNode) || !(singleReferenceContainerNode = (SingleReferenceContainerNode)result).getSingleReferenceType().equals(referenceType)) continue;
            return singleReferenceContainerNode;
        }
        throw new IllegalStateException("Can't go up to single reference container node of type: " + referenceType.getName() + " from node: " + node);
    }

    public static SingleReferenceContainerNode<?, ?> downToSingleReferenceContainerNode(Class<?> referenceType, MutableTreeNode node) {
        SingleReferenceContainerNode singleReferenceContainerNode;
        if (node instanceof SingleReferenceContainerNode && (singleReferenceContainerNode = (SingleReferenceContainerNode)node).getSingleReferenceType().equals(referenceType)) {
            return singleReferenceContainerNode;
        }
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            SingleReferenceContainerNode singleReferenceContainerNode2;
            MutableTreeNode childrenNode = (MutableTreeNode)children.nextElement();
            if (!(childrenNode instanceof SingleReferenceContainerNode) || !(singleReferenceContainerNode2 = (SingleReferenceContainerNode)childrenNode).getSingleReferenceType().equals(referenceType)) continue;
            return singleReferenceContainerNode2;
        }
        throw new IllegalStateException("Can't go down to single reference container node of type: " + referenceType.getName() + " from node: " + node);
    }

    public Class<D> getSingleDtoType();

    public Class<R> getSingleReferenceType();

    default public ReferenceNode<D, R> getSingleReferenceNode() {
        Enumeration<? extends TreeNode> children = this.children();
        Class<R> singleReferenceType = this.getSingleReferenceType();
        while (children.hasMoreElements()) {
            ReferenceNode referenceNode;
            MutableTreeNode o = (MutableTreeNode)children.nextElement();
            if (!(o instanceof ReferenceNode) || !singleReferenceType.isAssignableFrom((referenceNode = (ReferenceNode)o).getReferenceReferenceType())) continue;
            return referenceNode;
        }
        return null;
    }

    default public R getSingleReference() {
        Enumeration<? extends TreeNode> children = this.children();
        Class<R> childrenReferenceType = this.getSingleReferenceType();
        while (children.hasMoreElements()) {
            ReferenceNode referenceNode;
            MutableTreeNode o = (MutableTreeNode)children.nextElement();
            if (!(o instanceof ReferenceNode) || !childrenReferenceType.isAssignableFrom((referenceNode = (ReferenceNode)o).getReferenceReferenceType())) continue;
            return referenceNode.getReference();
        }
        return null;
    }

    public ReferenceNode<D, R> newSingleChildNode(R var1);

    public ReferenceNode<D, R> newSingleChildNode(String var1);

    public TreeNode[] getPath();
}

