/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.gson;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.ird.observe.gson.ImmutableListAdapter;
import fr.ird.observe.gson.ImmutableSetAdapter;
import fr.ird.observe.spi.map.ImmutableSetDtoMap;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ImmutableSetDtoMapAdapter
implements JsonSerializer<ImmutableSetDtoMap>,
JsonDeserializer<ImmutableSetDtoMap> {
    public JsonElement serialize(ImmutableSetDtoMap src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        LinkedList<Class> types = new LinkedList<Class>();
        for (Object value : src.getTypes().values()) {
            Class key = (Class)value;
            types.add(key);
            jsonObject.add(key.getName(), context.serialize(src.get(key)));
        }
        jsonObject.add("types", context.serialize(types));
        return jsonObject;
    }

    public ImmutableSetDtoMap deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        Type typeTypes = ImmutableListAdapter.listOf(TypeToken.of(Class.class)).getType();
        JsonObject asJsonObject = json.getAsJsonObject();
        List types = (List)context.deserialize(asJsonObject.get("types"), typeTypes);
        ImmutableSetDtoMap.Builder builder = ImmutableSetDtoMap.builder();
        for (Class aClass : types) {
            Type typeData = ImmutableSetAdapter.setOf(TypeToken.of((Class)aClass)).getType();
            Set mapData = (Set)context.deserialize(asJsonObject.get(aClass.getName()), typeData);
            builder.put(aClass, mapData);
        }
        return builder.build();
    }
}

