/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.reference;

import com.google.common.base.MoreObjects;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceAware;
import fr.ird.observe.dto.referential.ReferentialDto;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ReferentialDtoReference<D extends ReferentialDto, R extends ReferentialDtoReference<D, R>>
extends DtoReference<D, R>
implements ReferentialDtoReferenceAware {
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_CODE = "code";
    private static final Logger log = LogManager.getLogger(ReferentialDtoReference.class);
    private final boolean needComment;
    private final boolean enabled;

    public static Set<Class<? extends ReferentialDtoReference<?, ?>>> filterReferentialReference(Collection<Class<?>> types) {
        return types.stream().filter(ReferentialDtoReference.class::isAssignableFrom).collect(Collectors.toSet());
    }

    protected ReferentialDtoReference(ReferentialDtoReferenceAware dto) {
        super(dto);
        this.enabled = dto.isEnabled();
        this.needComment = dto.isNeedComment();
    }

    @Override
    public boolean isNeedComment() {
        return this.needComment;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getDtoType().getSimpleName()).add("id", (Object)this.getId());
        if (log.isDebugEnabled()) {
            toStringHelper.add(PROPERTY_ENABLED, this.enabled).add("needComment", this.needComment).add("createDate", (Object)this.getCreateDate()).add("lastUpdateDate", (Object)this.getLastUpdateDate()).add("version", this.getVersion());
        }
        return toStringHelper.toString();
    }
}

