/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.decoration.decorators;

import fr.ird.observe.dto.reference.DtoReference;
import io.ultreia.java4all.i18n.I18n;
import java.io.Serializable;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.decorator.MultiJXPathDecorator;

public class ObserveDecorator<E>
extends MultiJXPathDecorator<E>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(ObserveDecorator.class);
    public static final String DEFAULT_SEPARATOR = "##";
    public static final String DEFAULT_SEPARATOR_REPLACEMENT = " - ";

    public ObserveDecorator(Class<E> internalClass, String expression) {
        super(internalClass, expression, DEFAULT_SEPARATOR, DEFAULT_SEPARATOR_REPLACEMENT);
    }

    public ObserveDecorator(Class<E> internalClass, String expression, String separator) {
        super(internalClass, expression, DEFAULT_SEPARATOR, separator);
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Comparable<Comparable<?>> getTokenValue(JXPathContext jxcontext, String token) {
        Comparable<Comparable<?>> value;
        try {
            String[] tokens = token.split("/");
            Object value0 = jxcontext.getValue(tokens[0]);
            value = value0 instanceof DtoReference ? this.getValueFromReference(tokens, (DtoReference)value0, 1) : (Comparable<Comparable<?>>)jxcontext.getValue(token);
            if (value == null) {
                value = this.getDefaultNullValue(token);
            }
        }
        catch (Exception e) {
            value = this.getDefaultUndefinedValue(token);
        }
        return value;
    }

    protected Comparable<Comparable<?>> getValueFromReference(String[] tokens, DtoReference<?, ?> referenceBean, int startIndex) {
        int max = tokens.length - 1;
        for (int i = startIndex; i < max; ++i) {
            if (!referenceBean.getPropertyNames().contains((Object)tokens[i])) continue;
            Serializable propertyValue = (Serializable)referenceBean.getPropertyValue(tokens[i]);
            if (!(propertyValue instanceof DtoReference)) {
                return this.getDefaultUndefinedValue(StringUtils.join((Object[])tokens, (String)"/"));
            }
            referenceBean = (DtoReference)propertyValue;
        }
        Comparable value = null;
        String lastToken = tokens[tokens.length - 1];
        value = referenceBean.getPropertyNames().contains((Object)lastToken) ? (Comparable)referenceBean.getPropertyValue(lastToken) : (Comparable)referenceBean.get(lastToken);
        return value;
    }

    protected Comparable<?> getDefaultUndefinedValue(String token) {
        if (log.isDebugEnabled()) {
            log.debug("No defined value for token [" + token + "]");
        }
        return I18n.t((String)"observe.common.none", (Object[])new Object[0]);
    }

    protected Comparable<?> getDefaultNullValue(String token) {
        if (log.isDebugEnabled()) {
            log.debug("Null value for token [" + token + "]");
        }
        return I18n.t((String)"observe.common.none", (Object[])new Object[0]);
    }
}

