/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.decoration;

import fr.ird.observe.dto.decoration.ReferentialLocaleConfig;
import fr.ird.observe.dto.decoration.decorators.DataReferenceDecorator;
import fr.ird.observe.dto.decoration.decorators.ObserveDecorator;
import fr.ird.observe.dto.decoration.decorators.ReferentialReferenceDecorator;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialLocale;
import fr.ird.observe.spi.model.initializer.GlobalModelInitializer;
import java.util.Objects;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorProvider;

public abstract class DecoratorServiceSupport<I extends GlobalModelInitializer>
extends DecoratorProvider {
    private final I initializer;
    private ReferentialLocale referentialLocale;

    public DecoratorServiceSupport(ReferentialLocaleConfig referentialLocaleConfig) {
        this.referentialLocale = Objects.requireNonNull(referentialLocaleConfig.getReferentialLocale());
        this.initializer = this.createDecoratorServiceInitializer();
        this.loadDecorators();
    }

    protected abstract I createDecoratorServiceInitializer();

    protected abstract void init(I var1);

    public ReferentialLocale getReferentialLocale() {
        return this.referentialLocale;
    }

    public void setReferentialLocale(ReferentialLocale referentialLocale) {
        this.referentialLocale = referentialLocale;
    }

    protected void loadDecorators() {
        if (this.referentialLocale == null) {
            return;
        }
        this.init(this.initializer);
    }

    public <T extends ReferentialDtoReference> ReferentialReferenceDecorator<T> getReferentialReferenceDecorator(Class<T> referenceType) {
        return (ReferentialReferenceDecorator)this.getDecoratorByType(referenceType);
    }

    public <R extends DataDtoReference> DataReferenceDecorator<R> getDataReferenceDecorator(Class<R> referenceType) {
        return (DataReferenceDecorator)this.getDecoratorByType(referenceType);
    }

    public <R extends DataDtoReference> DataReferenceDecorator<R> getDataReferenceDecorator(Class<R> referenceType, String context) {
        return (DataReferenceDecorator)this.getDecoratorByType(referenceType, context);
    }

    public <R extends DtoReference> Decorator<R> getReferenceDecorator(Class<R> referenceType) {
        ObserveDecorator decorator = DataDtoReference.class.isAssignableFrom(referenceType) ? this.getDataReferenceDecorator(referenceType) : this.getReferentialReferenceDecorator(referenceType);
        return decorator;
    }
}

