/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto;

import io.ultreia.java4all.config.ApplicationConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.config.Configurator;

public class ObserveUtil {
    public static final String SQL_GZ_EXTENSION_PATTERN = "^.+\\.sql\\.gz$";
    private static final String SQL_GZ_EXTENSION = ".sql.gz";

    public static <C extends Class<?>> List<C> sortTypes(Collection<C> types, Function<Class, String> function, Locale locale) {
        ArrayList<C> list = new ArrayList<C>(types);
        new ClassComparator<C>(function, locale).sort(list);
        return list;
    }

    public static void loadLogConfiguration(URL logInput, Path logFile, Supplier<ApplicationConfig> configSupplier) throws IOException {
        if (!Files.exists(logFile, new LinkOption[0])) {
            LinkedList<String> finalLogConfigurationProperties = new LinkedList<String>();
            ApplicationConfig applicationConfig = configSupplier.get();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(logInput.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    finalLogConfigurationProperties.add(applicationConfig.replaceRecursiveOptions(line));
                }
            }
            Files.write(logFile, finalLogConfigurationProperties, new OpenOption[0]);
        }
        Configurator.initialize(null, (String)logFile.toFile().getAbsolutePath());
    }

    public static void cleanMemory() {
        System.runFinalization();
        System.gc();
    }

    public static String addSqlGzExtension(String filePath) {
        if (!filePath.endsWith(SQL_GZ_EXTENSION)) {
            filePath = filePath + SQL_GZ_EXTENSION;
        }
        return filePath;
    }

    public static String removeSqlGzExtension(String filePath) {
        if (filePath.endsWith(SQL_GZ_EXTENSION)) {
            filePath = StringUtils.removeEnd((String)filePath, (String)SQL_GZ_EXTENSION);
        }
        return filePath;
    }

    public static boolean withSqlGzExtension(String filePath) {
        return filePath.endsWith(SQL_GZ_EXTENSION);
    }

    private static class ClassComparator<C extends Class<?>>
    implements Comparator<C> {
        private final Map<Class, String> cache = new HashMap<Class, String>();
        private final Function<Class, String> function;
        private final Collator collator;

        private ClassComparator(Function<Class, String> function, Locale locale) {
            this.function = function;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(0);
        }

        @Override
        public int compare(Class o1, Class o2) {
            String s1 = this.getValue(o1);
            String s2 = this.getValue(o2);
            return this.collator.compare(s1, s2);
        }

        String getValue(Class klass) {
            return this.cache.computeIfAbsent(klass, k -> this.function.apply(klass));
        }

        public void sort(List<C> list) {
            list.sort(this);
            this.cache.clear();
        }
    }
}

