package fr.ird.observe.spi.type;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;

/**
 * Created on 25/07/19.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since ?
 */
public class TypeTranslators {

    private static TypeTranslators INSTANCE;

    public static TypeTranslators get() {
        return INSTANCE == null ? INSTANCE = new TypeTranslators() : INSTANCE;
    }

    private Set<TypeTranslator> translators;

    public static String getDtoSimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return getTranslator(dataType).cleanType(dataType);
//        return cleanId(dataType.getName().substring(DTO_ROOT_PACKAGE_LENGTH));
    }

    public static String getEntitySimplifiedName(Class<?> dataType) {
        Objects.requireNonNull(dataType, " Null type given");
        return getTranslator(dataType).cleanType(dataType);
//        return cleanId(dataType.getName().substring(ENTITY_ROOT_PACKAGE_LENGTH));
    }

    private Set<TypeTranslator> getTranslators() {
        if (translators == null) {
            translators = new LinkedHashSet<>();
            for (TypeTranslator typeTranslator : ServiceLoader.load(TypeTranslator.class)) {
                translators.add(typeTranslator);
            }
        }
        return translators;
    }

    public static TypeTranslator getTranslator(Class<?> type) {
        return optionalTranslator(type).orElseThrow(() -> new IllegalStateException("Can't type type translator for type: " + type));
    }

    private static Optional<TypeTranslator> optionalTranslator(Class<?> type) {
        //TODO Use a LoadingCache
        return get().getTranslators().stream().filter(t -> t.acceptType(type)).findFirst();
    }
}
