package fr.ird.observe.spi.type;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Created on 25/07/19.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since ?
 */
public abstract class TypeTranslatorSupport implements TypeTranslator {

    private final String rootPackage;
    private final Class<?> type;
    private final List<String> suffixes;

    protected TypeTranslatorSupport(String rootPackage, Class<?> type, String... suffixes) {
        this.rootPackage = rootPackage;
        this.type = type;
        this.suffixes = Arrays.asList(suffixes);
    }

    @Override
    public boolean acceptType(Class<?> type) {
        return this.type.isAssignableFrom(type) && type.getPackage().getName().startsWith(rootPackage);
    }

    @Override
    public String cleanType(Class<?> type) {
        return cleanType(type.getName());
    }

    @Override
    public String cleanType(String fqn) {
        int lastIndex = fqn.lastIndexOf('.');
        return StringUtils.removeStart(fqn.substring(0, lastIndex ), rootPackage + ".") + "." + cleanSimpleName(fqn.substring(lastIndex + 1));
    }

    @Override
    public String cleanSimpleName(String simpleName) {
        for (String suffix : suffixes) {
            simpleName = StringUtils.removeEnd(simpleName, suffix);
        }
        return simpleName;
    }
}
