package fr.ird.observe.spi.map;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.spi.type.TypeTranslators;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * A special map to store string values using the {@link #key0(Class)} method to produce keys.
 * <p>
 * Created on 25/07/19.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since ?
 */
public class ImmutableTypedMap<V> {

    private final ImmutableMap<String, V> data;
    private final ImmutableMap<String, Class> types;

    public static <V> Builder<V> builder() {
        return new Builder<>();
    }

    protected ImmutableTypedMap(ImmutableTypedMap<V> dtoMap) {
        this.data = dtoMap.data;
        this.types = dtoMap.types;
    }

    protected ImmutableTypedMap(ImmutableMap<String, V> data, ImmutableMap<String, Class> types) {
        this.data = data;
        this.types = types;
    }

    public int size() {
        return data.size();
    }

    public boolean isEmpty() {
        return data.isEmpty();
    }

    public V get(Class key) {
        return data.get(key0(key));
    }

//    public V get(String key) {
//        return data.get(key0(key));
//    }

    public Set<String> keySet() {
        return data.keySet();
    }

    public Collection<V> values() {
        return data.values();
    }

    @SuppressWarnings("unchecked")
    public Collection<Class<?>> types() {
        return (Collection) types.values();
    }

//    @SuppressWarnings("unchecked")
//    public Set<Class<? extends ReferentialDtoReference>> referentialReferenceTypes() {
//        return (Set) types.values().stream().filter(IdHelper::isReferential).collect(Collectors.toSet());
//    }

//    @SuppressWarnings("unchecked")
//    public Set<Class<? extends ReferentialDto>> referentialTypes() {
//        return (Set) types.values().stream().filter(IdHelper::isReferential).collect(Collectors.toSet());
//    }

//    @SuppressWarnings("unchecked")
//    public Set<Class<? extends DataDtoReference>> dataReferenceTypes() {
//        return (Set) types.values().stream().filter(IdHelper::isData).collect(Collectors.toSet());
//    }
//    @SuppressWarnings("unchecked")
//    public Set<Class<? extends DataDto>> dataTypes() {
//        return (Set) types.values().stream().filter(IdHelper::isData).collect(Collectors.toSet());
//    }

//    public boolean containsEntry(Class type, V value) {
//        String key = key0(type);
//        return data.containsKey(key) && data.values().contains(value);
//    }

    public static class Builder<V> {

        private final Map<String, V> data;

        private final Map<String, Class> types;

        private Builder() {
            this.data = new LinkedHashMap<>();
            this.types = new LinkedHashMap<>();
        }

        public Builder put(Class type, V value) {
            String key = key0(type);
            data.put(key, value);
            types.put(key, type);
            return this;
        }

        public ImmutableTypedMap<V> build() {
            return new ImmutableTypedMap<>(ImmutableMap.copyOf(data), ImmutableMap.copyOf(types));
        }

        public V get(Class<?> type) {
            return data.get(type);
        }
    }

    private static String key0(Class type) {
        return TypeTranslators.getTranslator(type).cleanType(type);
    }
}
