package fr.ird.observe.spi.map;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;

import java.util.Collection;

/**
 * Created by tchemit on 02/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class DtoToReferenceClassMap {

    private final ImmutableTypedMap<Class> dtoMap;

    public DtoToReferenceClassMap(ImmutableTypedMap<Class> dtoMap) {
        this.dtoMap = dtoMap;
    }

    public <D extends DataDto, R extends DataDtoReference<D, R>> Class<R> forData(Class<D> key) {
        return get0(key);
    }

    public <D extends DataDto, R extends DataDtoReference<D, R>> Class<R> forData(D key) {
        return get0(key.getClass());
    }

    public <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> Class<R> forReferential(Class<D> key) {
        return get0(key);
    }

    public <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> Class<R> forReferential(D key) {
        return get0(key.getClass());
    }

    @SuppressWarnings("unchecked")
    private <D extends IdDto, R extends DtoReference<D, R>> Class<R> get0(Class key) {
        return dtoMap.get(key);
    }

    public Collection<Class> values() {
        return dtoMap.values();
    }

    public int size() {
        return dtoMap.size();
    }

}
