package fr.ird.observe.spi.map;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.referential.ReferentialDto;
import org.checkerframework.checker.units.qual.K;

import java.util.Collection;
import java.util.Set;

/**
 * Created by tchemit on 02/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class DtoToDtoClassMap {

    private final ImmutableMap<Class, Class> dtoMap;

    public DtoToDtoClassMap(ImmutableMap<Class, Class> dtoMap) {
        this.dtoMap = dtoMap;
    }

    public <K extends IdDto, D extends IdDto> Class<D> forDto(Class<K> key) {
        return get0(key);
    }

    public <K extends DataDto, D extends DataDto> Class<D> forData(Class<K> key) {
        return get0(key);
    }

    public <K extends DataDto, D extends DataDto> Class<D> forData(K key) {
        return get0(key.getClass());
    }

    public <K extends ReferentialDto, D extends ReferentialDto> Class<D> forReferential(Class<K> key) {
        return get0(key);
    }

    public <K extends ReferentialDto, D extends ReferentialDto> Class<D> forReferential(K key) {
        return get0(key.getClass());
    }

    @SuppressWarnings("unchecked")
    public <D extends IdDto> Class<D> get0(Class key) {
        return dtoMap.get(key);
    }

    public Collection<Class> values() {
        return dtoMap.values();
    }

    public int size() {
        return dtoMap.size();
    }

    public Set<Class> keys() {
        return dtoMap.keySet();
    }
}
