package fr.ird.observe.spi.initializer;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.binder.data.DataDtoReferenceBinder;
import fr.ird.observe.binder.referential.ReferentialDtoReferenceBinder;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DataDtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReferenceDefinition;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.spi.map.DtoToReferenceClassMap;
import fr.ird.observe.spi.map.ImmutableTypedMap;
import fr.ird.observe.spi.map.ReferenceToDtoClassMap;

import java.util.LinkedHashSet;
import java.util.Set;

public abstract class DtoReferencesInitializerSupport {

    private final ImmutableTypedMap.Builder<ReferentialDtoReferenceDefinition> referentialReferenceSetDefinitionBuilder = ImmutableTypedMap.builder();

    private final ImmutableTypedMap.Builder<DataDtoReferenceDefinition> dataReferenceSetDefinitionBuilder = ImmutableTypedMap.builder();

    private final Set<Class<? extends ReferentialDto>> referentialTypesBuilder = new LinkedHashSet<>();

    private final Set<Class<? extends DataDto>> dataTypesBuilder = new LinkedHashSet<>();

    private final ImmutableTypedMap.Builder<Class> dtoToReferenceClassMappingBuilder = ImmutableTypedMap.builder();

    private final ImmutableTypedMap.Builder<Class> referenceToDtoClassMappingBuilder = ImmutableTypedMap.builder();

    private final ImmutableTypedMap.Builder<ReferentialDtoReferenceBinder> referentialBindersBuilder = ImmutableTypedMap.builder();

    private final ImmutableTypedMap.Builder<DataDtoReferenceBinder> dataBindersBuilder = ImmutableTypedMap.builder();

    private ImmutableTypedMap<ReferentialDtoReferenceDefinition> referentialReferenceSetDefinition;

    private ImmutableTypedMap<DataDtoReferenceDefinition> dataReferenceSetDefinition;

    private ImmutableSet<Class<? extends ReferentialDto>> referentialTypes;

    private ImmutableSet<Class<? extends DataDto>> dataTypes;

    private DtoToReferenceClassMap dtoToReferenceClassMapping;

    private ReferenceToDtoClassMap referenceToDtoClassMapping;

    private ImmutableTypedMap<ReferentialDtoReferenceBinder> referentialBinders;

    private ImmutableTypedMap<DataDtoReferenceBinder> dataBinders;

    public ImmutableTypedMap<ReferentialDtoReferenceDefinition> getReferentialReferenceSetDefinition() {
        return referentialReferenceSetDefinition;
    }

    public ImmutableTypedMap<DataDtoReferenceDefinition> getDataReferenceSetDefinition() {
        return dataReferenceSetDefinition;
    }

    public ImmutableSet<Class<? extends ReferentialDto>> getReferentialTypes() {
        return referentialTypes;
    }

    public ImmutableSet<Class<? extends DataDto>> getDataTypes() {
        return dataTypes;
    }

    public DtoToReferenceClassMap getDtoToReferenceClassMapping() {
        return dtoToReferenceClassMapping;
    }

    public ReferenceToDtoClassMap getReferenceToDtoClassMapping() {
        return referenceToDtoClassMapping;
    }

    public ImmutableTypedMap<ReferentialDtoReferenceBinder> getReferentialBinders() {
        return referentialBinders;
    }

    public ImmutableTypedMap<DataDtoReferenceBinder> getDataBinders() {
        return dataBinders;
    }

    public void end() {
        referentialReferenceSetDefinition = referentialReferenceSetDefinitionBuilder.build();
        dataReferenceSetDefinition = dataReferenceSetDefinitionBuilder.build();
        referentialTypes = ImmutableSet.copyOf(referentialTypesBuilder);
        dataTypes = ImmutableSet.copyOf(dataTypesBuilder);
        dtoToReferenceClassMapping = new DtoToReferenceClassMap(dtoToReferenceClassMappingBuilder.build());
        referenceToDtoClassMapping = new ReferenceToDtoClassMap(referenceToDtoClassMappingBuilder.build());
        referentialBinders = referentialBindersBuilder.build();
        dataBinders = dataBindersBuilder.build();
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>> void flushReferential(ReferentialDtoReferenceDefinition<D, R> result) {
        referentialTypesBuilder.add(result.getDtoType());
        referentialReferenceSetDefinitionBuilder.put(result.getType(), result);
        dtoToReferenceClassMappingBuilder.put(result.getDtoType(), result.getType());
        referenceToDtoClassMappingBuilder.put(result.getType(), result.getDtoType());

    }

    protected <D extends DataDto, R extends DataDtoReference<D, R>> void flushData(DataDtoReferenceDefinition<D, R> result) {
        dataTypesBuilder.add(result.getDtoType());
        dataReferenceSetDefinitionBuilder.put(result.getType(), result);
        dtoToReferenceClassMappingBuilder.put(result.getDtoType(), result.getType());
        referenceToDtoClassMappingBuilder.put(result.getType(), result.getDtoType());
    }

    protected <D extends ReferentialDto, R extends ReferentialDtoReference<D, R>, B extends ReferentialDtoReferenceBinder<D, R>> void registerReferentialBinder(B binder) {
        referentialBindersBuilder.put(binder.getDtoType(), binder);
    }

    protected <D extends DataDto, R extends DataDtoReference<D, R>, B extends DataDtoReferenceBinder<D, R>> void registerDataBinder(B binder) {
        dataBindersBuilder.put(binder.getDtoType(), binder);
    }
}
