package fr.ird.observe.gson;

/*
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.ird.observe.spi.map.ImmutableSetDtoMap;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * Created by tchemit on 17/09/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class ImmutableSetDtoMapAdapter implements JsonSerializer<ImmutableSetDtoMap>, JsonDeserializer<ImmutableSetDtoMap> {

    @Override
    public JsonElement serialize(ImmutableSetDtoMap src, Type typeOfSrc, JsonSerializationContext context) {

        JsonObject jsonObject = new JsonObject();
        List<Class> types = new LinkedList<>();
        for (Object value : src.getTypes().values()) {
            Class key = (Class) value;
            types.add(key);
            jsonObject.add(key.getName(), context.serialize(src.get(key)));
        }
        jsonObject.add("types", context.serialize(types));
        return jsonObject;
    }

    @Override
    public ImmutableSetDtoMap deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {

        Type typeTypes = ImmutableListAdapter.listOf(TypeToken.of(Class.class)).getType();
        JsonObject asJsonObject = json.getAsJsonObject();
        List<Class<?>> types = context.deserialize(asJsonObject.get("types"), typeTypes);
        ImmutableSetDtoMap.Builder<Object> builder = ImmutableSetDtoMap.builder();

        for (Class<?> aClass : types) {
            Type typeData = ImmutableSetAdapter.setOf(TypeToken.of(aClass)).getType();
            Set<?> mapData = context.deserialize(asJsonObject.get(aClass.getName()), typeData);
            builder.put(aClass, mapData);
        }
        return builder.build();
    }

}
