package fr.ird.observe.gson;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.ird.observe.navigation.model.DtoModelNavigationModel;
import fr.ird.observe.navigation.model.DtoModelNavigationNode;
import io.ultreia.java4all.lang.Objects2;

import java.lang.reflect.Type;
import java.util.Map;

/**
 * Created by tchemit on 28/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class DtoModelNavigationModelAdapter implements JsonSerializer<DtoModelNavigationModel<?>>, JsonDeserializer<DtoModelNavigationModel<?>> {

    @Override
    public JsonElement serialize(DtoModelNavigationModel<?> src, Type typeOfSrc, JsonSerializationContext context) {
        ImmutableMap.Builder<Class<? extends DtoModelNavigationNode>, String> builder = ImmutableMap.builder();
        for (DtoModelNavigationNode<?> node : src.getNodesWithIds()) {
            builder.put(node.getClass(), node.getId());
        }
        return context.serialize(new DtoModelNavigationModelStr(src.getClass(), builder.build()));
    }

    @Override
    public DtoModelNavigationModel deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        DtoModelNavigationModelStr deserialize = context.deserialize(json, DtoModelNavigationModelStr.class);
        Class<? extends DtoModelNavigationModel> modelType = deserialize.getType();
        DtoModelNavigationModel result = Objects2.newInstance(modelType);
        for (Map.Entry<Class<? extends DtoModelNavigationNode>, String> entry : deserialize.getIds().entrySet()) {
            DtoModelNavigationNode<?> model = result.getNode(entry.getKey());
            model.setId(entry.getValue());
        }
        return result;
    }

    static class DtoModelNavigationModelStr {

        private final Class<? extends DtoModelNavigationModel> type;
        private final ImmutableMap<Class<? extends DtoModelNavigationNode>, String> ids;

        DtoModelNavigationModelStr(Class<? extends DtoModelNavigationModel> type, ImmutableMap<Class<? extends DtoModelNavigationNode>, String> ids) {
            this.type = type;
            this.ids = ids;
        }

        public Class<? extends DtoModelNavigationModel> getType() {
            return type;
        }

        public ImmutableMap<Class<? extends DtoModelNavigationNode>, String> getIds() {
            return ids;
        }
    }
}
