package fr.ird.observe.dto.referential;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Ordering;

import java.util.Comparator;
import java.util.Date;

/**
 * Created by tchemit on 10/07/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public interface WithStartEndDate /*extends DtoReferenceAware*/ {

    Comparator<Date> START_DATE_COMPARATOR = Ordering.natural().nullsFirst();
    Comparator<Date> END_DATE_COMPARATOR = Ordering.natural().nullsLast();

    Comparator<WithStartEndDate> WITH_START_DATE_COMPARATOR = Comparator.comparing(WithStartEndDate::getStartDate, START_DATE_COMPARATOR);
    Comparator<WithStartEndDate> WITH_END_DATE_COMPARATOR = Comparator.comparing(WithStartEndDate::getEndDate, END_DATE_COMPARATOR);

    Date getStartDate();

    Date getEndDate();

}
