package fr.ird.observe.dto.model;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.referential.ReferentialDto;
import io.ultreia.java4all.util.ServiceLoaders;

import java.util.ServiceLoader;

/**
 * Created by tchemit on 26/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class AggregateDtoModel implements DtoModel {

    private static AggregateDtoModel instance;
    private final String name;
    private final ImmutableSet<DtoModel> models;
    private final ImmutableSet<Class<? extends ReferentialDto>> referentialTypes;
    private final ImmutableSet<Class<? extends DataDto>> dataTypes;

    protected AggregateDtoModel(String name) {
        this.name = name;
        ImmutableSet.Builder<DtoModel> modelsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder<Class<? extends ReferentialDto>> referentialTypes = ImmutableSet.builder();
        ImmutableSet.Builder<Class<? extends DataDto>> dataTypes = ImmutableSet.builder();
        for (DtoModel dtoModel : ServiceLoader.load(DtoModel.class)) {
            modelsBuilder.add(dtoModel);
            referentialTypes.addAll(dtoModel.getReferentialTypes());
            dataTypes.addAll(dtoModel.getDataTypes());
        }
        this.referentialTypes = referentialTypes.build();
        this.dataTypes = dataTypes.build();
        this.models = modelsBuilder.build();
    }

    public static synchronized AggregateDtoModel get() {
        return instance == null ? instance = ServiceLoaders.loadUniqueService(AggregateDtoModel.class) : instance;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public ImmutableSet<Class<? extends ReferentialDto>> getReferentialTypes() {
        return referentialTypes;
    }

    @Override
    public ImmutableSet<Class<? extends DataDto>> getDataTypes() {
        return dataTypes;
    }

    public ImmutableSet<DtoModel> getModels() {
        return models;
    }
}
