package fr.ird.observe.dto.decoration;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.ObserveUtil;
import io.ultreia.java4all.i18n.spi.bean.BeanPropertyI18nKeyProducerProvider;

import java.util.Collection;
import java.util.List;
import java.util.Locale;

import static io.ultreia.java4all.i18n.I18n.t;

/**
 * Created on 03/09/16.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 5.0
 */
public abstract class I18nDecoratorHelper extends BeanPropertyI18nKeyProducerProvider {

    public static I18nDecoratorHelper get() {
        return (I18nDecoratorHelper) BeanPropertyI18nKeyProducerProvider.get();
    }

    public static <C extends Class<?>> List<C> sortTypes(Collection<C> types, Locale locale) {
        return ObserveUtil.sortTypes(types, klass -> t(getTypeI18nKey(klass)), locale);
    }

    public static String getTypeI18nKey(Class key) {
        return load(key) + ".type";
    }

    public static String getPropertyI18nKey(Class type, String propertyName) {
        I18nDecoratorHelper i18nDecoratorHelper = get();
        return i18nDecoratorHelper.getDefaultLabelsBuilder().getI18nPropertyKey(type, propertyName);
    }

    private static String load(Class key) {
        I18nDecoratorHelper i18nDecoratorHelper = get();
        return i18nDecoratorHelper.getCommonPrefix() + i18nDecoratorHelper.getDefaultLabelsBuilder().getI18nTypeKey(key);
    }

}
