package fr.ird.observe.dto.decoration;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ird.observe.dto.decoration.decorators.DataReferenceDecorator;
import fr.ird.observe.dto.decoration.decorators.ReferentialReferenceDecorator;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialLocale;
import fr.ird.observe.spi.model.initializer.GlobalModelInitializer;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorProvider;

import java.util.Objects;

public abstract class DecoratorServiceSupport<I extends GlobalModelInitializer> extends DecoratorProvider {

    private final I initializer;
    private ReferentialLocale referentialLocale;

    public DecoratorServiceSupport(ReferentialLocaleConfig referentialLocaleConfig) {
        this.referentialLocale = Objects.requireNonNull(referentialLocaleConfig.getReferentialLocale());
        this.initializer = createDecoratorServiceInitializer();
        loadDecorators();
    }

    protected abstract I createDecoratorServiceInitializer();

    protected abstract void init(I initializer);

    public ReferentialLocale getReferentialLocale() {
        return referentialLocale;
    }

    public void setReferentialLocale(ReferentialLocale referentialLocale) {
        this.referentialLocale = referentialLocale;
    }

    @Override
    protected void loadDecorators() {
        if (referentialLocale == null) {
            // on n'enregistre pas les décorateur tant que la locale n'est pas
            // positionnée
            return;
        }
        init(initializer);
    }


    public <T extends ReferentialDtoReference> ReferentialReferenceDecorator<T> getReferentialReferenceDecorator(Class<T> referenceType) {
        return (ReferentialReferenceDecorator) getDecoratorByType(referenceType);
    }

    public <R extends DataDtoReference> DataReferenceDecorator<R> getDataReferenceDecorator(Class<R> referenceType) {
        return (DataReferenceDecorator) getDecoratorByType(referenceType);
    }

    public <R extends DataDtoReference> DataReferenceDecorator<R> getDataReferenceDecorator(Class<R> referenceType, String context) {
        return (DataReferenceDecorator) getDecoratorByType(referenceType, context);
    }

    public <R extends DtoReference> Decorator<R> getReferenceDecorator(Class<R> referenceType) {
        Decorator<R> decorator;

        if (DataDtoReference.class.isAssignableFrom(referenceType)) {
            decorator = getDataReferenceDecorator((Class) referenceType);
        } else {
            decorator = getReferentialReferenceDecorator((Class) referenceType);
        }

        return decorator;
    }
}
