package fr.ird.observe.dto.data;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2020 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */


import fr.ird.observe.dto.IdDto;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class DataDto extends IdDto {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_HOME_ID = "homeId";

    private String homeId;

    @SuppressWarnings("unchecked")
    public static Set<Class<? extends DataDto>> filterDataDto(Collection<Class<? extends IdDto>> types) {
        return (Set) types.stream().filter(DataDto.class::isAssignableFrom).collect(Collectors.toSet());
    }

    public String getHomeId() {
        return homeId;
    }

    public void setHomeId(String homeId) {
        String oldValue = getHomeId();
        this.homeId = homeId;
        firePropertyChange(PROPERTY_HOME_ID, oldValue, homeId);
    }
}
