/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdHelper;
import java.util.Collection;
import java.util.Set;

public class ImmutableEntityMap<V> {
    private final ImmutableMap<String, V> data;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    protected ImmutableEntityMap(ImmutableEntityMap<V> dtoMap) {
        this.data = dtoMap.data;
    }

    protected ImmutableEntityMap(ImmutableMap<String, V> data) {
        this.data = data;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public V get(Class key) {
        return (V)this.data.get((Object)this.key0(key));
    }

    public V get(String key) {
        return (V)this.data.get((Object)this.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<V> values() {
        return this.data.values();
    }

    public boolean containsEntry(Class type, V value) {
        String key = this.key0(type);
        return this.data.containsKey((Object)key) && this.data.values().contains(value);
    }

    private String key0(String type) {
        return IdHelper.getEntitySimplifiedName(type);
    }

    private String key0(Class type) {
        return IdHelper.getEntitySimplifiedName(type);
    }

    public static class Builder<V> {
        private final ImmutableMap.Builder<String, V> data = ImmutableMap.builder();

        private Builder() {
        }

        public Builder put(Class type, V value) {
            this.data.put((Object)IdHelper.getEntitySimplifiedName(type), value);
            return this;
        }

        public ImmutableEntityMap<V> build() {
            return new ImmutableEntityMap(this.data.build());
        }
    }
}

