/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.dto.navigation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.navigation.DtoModelNavigationModel;
import fr.ird.observe.dto.navigation.DtoModelNavigationNode;
import fr.ird.observe.dto.navigation.DtoModelNavigationNodeDefinition;
import io.ultreia.java4all.bean.AbstractJavaBean;
import io.ultreia.java4all.lang.Objects2;
import io.ultreia.java4all.util.ServiceLoaders;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;

public abstract class DtoModelNavigationModelSupport<N extends DtoModelNavigationNode<?>>
extends AbstractJavaBean
implements DtoModelNavigationModel<N> {
    private final ImmutableList<N> nodes;
    private final N root;

    protected DtoModelNavigationModelSupport() {
        Class nodeType = (Class)((ParameterizedType)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getRawType();
        ImmutableMap.Builder nodesAnnotationBuilders = ImmutableMap.builder();
        ImmutableMap.Builder parentBuilders = ImmutableMap.builder();
        this.nodes = Objects.requireNonNull(this.loadNodes(nodeType, nodesAnnotationBuilders, parentBuilders));
        this.root = (DtoModelNavigationNode)Objects.requireNonNull(this.loadRoot(nodeType, parentBuilders.build(), nodesAnnotationBuilders.build()));
        this.root.addPropertyChangeListener("enabled", e -> {
            boolean oldValue = (Boolean)e.getOldValue();
            boolean newValue = (Boolean)e.getNewValue();
            this.firePropertyChange("enabled", oldValue, newValue);
        });
    }

    @Override
    public boolean accept(IdDto dto) {
        return this.nodes.stream().anyMatch(n -> n.accept(dto));
    }

    @Override
    public <D extends DtoModelNavigationNode> D getNode(Class<D> type) {
        return (D)((DtoModelNavigationNode)this.nodes.stream().filter(n -> type.equals(n.getClass())).findFirst().orElse(null));
    }

    @Override
    public N getRoot() {
        return this.root;
    }

    @Override
    public ImmutableList<N> getNodes() {
        return this.nodes;
    }

    @Override
    public ImmutableList<N> getNodesWithIds() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.root.getIds(builder);
        return builder.build();
    }

    protected ImmutableList<N> loadNodes(Class<N> nodeType, ImmutableMap.Builder<N, Class<? extends DtoModelNavigationNode<?>>[]> nodesAnnotationBuilders, ImmutableMap.Builder<Class<? extends DtoModelNavigationNode<?>>, N> parentBuilders) {
        ImmutableList.Builder nodesBuilders = ImmutableList.builder();
        for (Class thisNodeType : ServiceLoaders.loadTypes(nodeType)) {
            DtoModelNavigationNode node = (DtoModelNavigationNode)Objects2.newInstance((Class)thisNodeType);
            nodesBuilders.add((Object)node);
            DtoModelNavigationNodeDefinition annotation = Objects.requireNonNull(node.getClass().getAnnotation(DtoModelNavigationNodeDefinition.class));
            Class<? extends DtoModelNavigationNode<?>>[] children = annotation.value();
            if (children.length <= 0) continue;
            nodesAnnotationBuilders.put((Object)node, children);
            for (Class<? extends DtoModelNavigationNode<?>> child : children) {
                parentBuilders.put(child, (Object)node);
            }
        }
        return nodesBuilders.build();
    }

    protected N loadRoot(Class<N> nodeType, ImmutableMap<Class<? extends DtoModelNavigationNode<?>>, N> parentMap, ImmutableMap<N, Class<? extends DtoModelNavigationNode<?>>[]> annotations) {
        DtoModelNavigationNode root = null;
        for (DtoModelNavigationNode node : this.nodes) {
            DtoModelNavigationNode parentNode = (DtoModelNavigationNode)parentMap.get(node.getClass());
            Class[] children = (Class[])annotations.get((Object)node);
            ImmutableList.Builder childrenNodes = ImmutableList.builder();
            if (children != null) {
                ImmutableMap nodesByClass = Maps.uniqueIndex(this.nodes, Object::getClass);
                for (Class child : children) {
                    childrenNodes.add(Objects.requireNonNull(nodesByClass.get((Object)child), "can't find node of type: " + child));
                }
            }
            node.init(parentNode, childrenNodes.build());
        }
        for (DtoModelNavigationNode node : this.nodes) {
            if (!node.isRoot()) continue;
            if (root != null) {
                throw new IllegalStateException(String.format("Found two root node: %s and %s", root, node));
            }
            root = node;
        }
        return (N)((DtoModelNavigationNode)Objects.requireNonNull(root, String.format("Could not find a root node of type: %s", nodeType)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DtoModelNavigationModelSupport that = (DtoModelNavigationModelSupport)o;
        return Objects.equals(this.nodes, that.nodes) && Objects.equals(this.root, that.root);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.root);
    }
}

