package fr.ird.observe.spi.map;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2018 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdHelper;
import java.util.Collection;
import java.util.Set;

/**
 * A special map to store string values using the {@link #key0(Class)} method to produce keys.
 * <p>
 * Created by tchemit on 01/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class ImmutableEntityMap<V> {

    private final ImmutableMap<String, V> data;

    public static <V> Builder<V> builder() {
        return new Builder<>();
    }

    protected ImmutableEntityMap(ImmutableEntityMap<V> dtoMap) {
        this.data = dtoMap.data;
    }

    protected ImmutableEntityMap(ImmutableMap<String, V> data) {
        this.data = data;
    }

    public int size() {
        return data.size();
    }

    public boolean isEmpty() {
        return data.isEmpty();
    }

    public V get(Class key) {
        return data.get(key0(key));
    }

    public V get(String key) {
        return data.get(key0(key));
    }

    public Set<String> keySet() {
        return data.keySet();
    }

    public Collection<V> values() {
        return data.values();
    }

    public boolean containsEntry(Class type, V value) {
        String key = key0(type);
        return data.containsKey(key) && data.values().contains(value);
    }

    public static class Builder<V> {

        private final ImmutableMap.Builder<String, V> data;

        private Builder() {
            this.data = ImmutableMap.builder();
        }

        public Builder put(Class type, V value) {
            data.put(IdHelper.getEntitySimplifiedName(type), value);
            return this;
        }

        public ImmutableEntityMap<V> build() {
            return new ImmutableEntityMap<>(data.build());
        }

    }

    private String key0(String type) {
        return IdHelper.getEntitySimplifiedName(type);
    }

    private String key0(Class type) {
        return IdHelper.getEntitySimplifiedName(type);
    }
}
