package fr.ird.observe.gson;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2018 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import fr.ird.observe.dto.navigation.DtoModelNavigationAggregateModel;
import fr.ird.observe.dto.navigation.DtoModelNavigationModel;
import fr.ird.observe.dto.navigation.DtoModelNavigationNode;
import io.ultreia.java4all.lang.Objects2;

import java.lang.reflect.Type;
import java.util.Map;

/**
 * Created by tchemit on 28/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class DtoModelNavigationAggregateModelAdapter implements JsonSerializer<DtoModelNavigationAggregateModel>, JsonDeserializer<DtoModelNavigationAggregateModel> {

    @Override
    public JsonElement serialize(DtoModelNavigationAggregateModel src, Type typeOfSrc, JsonSerializationContext context) {
        ImmutableMap.Builder<Class<? extends DtoModelNavigationModel<?>>, ImmutableMap<Class<? extends DtoModelNavigationNode<?>>, String>> builder = ImmutableMap.builder();
        for (DtoModelNavigationModel<?> model : src.getEnabledModels()) {

            ImmutableMap.Builder<Class<? extends DtoModelNavigationNode<?>>, String> nodeBuilder = ImmutableMap.builder();
            for (DtoModelNavigationNode<?> node : model.getNodesWithIds()) {
                nodeBuilder.put((Class) node.getClass(), node.getId());
            }
            builder.put((Class<? extends DtoModelNavigationModel<?>>) model.getClass(), nodeBuilder.build());
        }
        return context.serialize(builder.build());
    }

    @Override
    public DtoModelNavigationAggregateModel deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {

        ImmutableMap<Class<? extends DtoModelNavigationModel<?>>, ImmutableMap<Class<? extends DtoModelNavigationNode<?>>, String>> models = context.deserialize(json, new TypeToken<ImmutableMap<Class<? extends DtoModelNavigationModel<?>>, ImmutableMap<Class<? extends DtoModelNavigationNode<?>>, String>>>() {
        }.getType());
        DtoModelNavigationAggregateModel result = (DtoModelNavigationAggregateModel) Objects2.newInstance((Class) type);
        for (Map.Entry<Class<? extends DtoModelNavigationModel<?>>, ImmutableMap<Class<? extends DtoModelNavigationNode<?>>, String>> entry : models.entrySet()) {
            DtoModelNavigationModel<?> model = result.forModelType(entry.getKey()).get();
            for (Map.Entry<Class<? extends DtoModelNavigationNode<?>>, String> nodeEntry : entry.getValue().entrySet()) {
                model.getNode(nodeEntry.getKey()).setId(nodeEntry.getValue());
            }
        }
        return result;
    }

    static class DtoModelNavigationAggregateModelStr {

        private final Class<? extends DtoModelNavigationAggregateModel> type;
        private final ImmutableList<? extends DtoModelNavigationModel<?>> models;

        DtoModelNavigationAggregateModelStr(Class<? extends DtoModelNavigationAggregateModel> type, ImmutableList<? extends DtoModelNavigationModel<?>> models) {
            this.type = type;
            this.models = models;
        }

        public Class<? extends DtoModelNavigationAggregateModel> getType() {
            return type;
        }

        public ImmutableList<? extends DtoModelNavigationModel<?>> getModels() {
            return models;
        }
    }
}
