package fr.ird.observe.dto.reference;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2018 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.data.DataDto;
import java.util.function.Function;

/**
 * Describe the definition of a reference on a dto.
 * <p>
 * Created on 11/11/15.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class DataDtoReferenceDefinition<D extends DataDto, R extends DataDtoReference<D, R>> extends DtoReferenceDefinition<D, R> {

    private static final long serialVersionUID = 1L;

    public static <D extends DataDto, R extends DataDtoReference<D, R>> Builder<D, R, DataDtoReferenceDefinition<D, R>> builder(Class<D> dtoType, Class<R> type) {
        return new Builder<D, R, DataDtoReferenceDefinition<D, R>>(dtoType, type) {
            @Override
            public DataDtoReferenceDefinition<D, R> build() {
                return new DataDtoReferenceDefinition<>(dtoType, referenceType, propertiesBuilder.build(), functionsBuilder.build());
            }
        };
    }

    protected DataDtoReferenceDefinition(Class<D> dtoType, Class<R> referenceType, ImmutableMap<String, Class<?>> properties, ImmutableMap<String, Function<R, ?>> functions) {
        super(dtoType, referenceType, properties, functions);
    }

}
