package fr.ird.observe.dto.navigation;

/*-
 * #%L
 * ObServe Toolkit :: Common Dto
 * %%
 * Copyright (C) 2017 - 2018 IRD, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableList;
import fr.ird.observe.dto.IdDto;
import io.ultreia.java4all.bean.JavaBean;

/**
 * Created by tchemit on 26/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public interface DtoModelNavigationNode<D extends IdDto> extends JavaBean {

    String PROPERTY_ID = "id";

    String PROPERTY_ENABLED = "enabled";

    Class<D> getType();

    int getLevel();

    boolean accept(IdDto dto);

    String getId();

    void setId(String id);

    DtoModelNavigationNode<?> getParent();

    ImmutableList<DtoModelNavigationNode<?>> getChildren();

    <N extends DtoModelNavigationNode<?>> void init(N parentNode, ImmutableList<DtoModelNavigationNode<?>> nodeStore);

    @SuppressWarnings("unchecked")
    default DtoModelNavigationNode<?> getRoot() {
        return isRoot() ? this : getParent().getRoot();
    }

    default boolean isRoot() {
        return getParent() == null;
    }

    default boolean isLeaf() {
        return getChildren().isEmpty();
    }

    default boolean isEnabled() {
        return getId() != null;
    }

    default boolean isDisabled() {
        return !isEnabled();
    }

    @SuppressWarnings("unchecked")
    default <N extends DtoModelNavigationNode<?>> void getIds(ImmutableList.Builder<N> builder) {
        if (this.isEnabled()) {
            builder.add((N) this);
            for (DtoModelNavigationNode<?> child : getChildren()) {
                child.getIds(builder);
            }
        }
    }
}
