/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.map;

import com.google.common.collect.ImmutableMap;
import fr.ird.observe.dto.IdHelper;
import fr.ird.observe.dto.data.DataDto;
import fr.ird.observe.dto.reference.DataDtoReference;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ImmutableDtoMap<V> {
    private static final transient Function<Class, String> keyFunction = IdHelper::getDtoSimplifiedName;
    private final ImmutableMap<String, V> data;
    private final ImmutableMap<String, Class> types;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    protected ImmutableDtoMap(ImmutableDtoMap<V> dtoMap) {
        this.data = dtoMap.data;
        this.types = dtoMap.types;
    }

    protected ImmutableDtoMap(ImmutableMap<String, V> data, ImmutableMap<String, Class> types) {
        this.data = data;
        this.types = types;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public V get(Class key) {
        return (V)this.data.get((Object)this.key0(key));
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Collection<V> values() {
        return this.data.values();
    }

    public Set<Class<? extends ReferentialDtoReference>> referentialReferenceTypes() {
        return this.types.values().stream().filter(IdHelper::isReferential).collect(Collectors.toSet());
    }

    public Set<Class<? extends ReferentialDto>> referentialTypes() {
        return this.types.values().stream().filter(IdHelper::isReferential).collect(Collectors.toSet());
    }

    public Set<Class<? extends DataDtoReference>> dataReferenceTypes() {
        return this.types.values().stream().filter(IdHelper::isData).collect(Collectors.toSet());
    }

    public Set<Class<? extends DataDto>> dataTypes() {
        return this.types.values().stream().filter(IdHelper::isData).collect(Collectors.toSet());
    }

    public boolean containsEntry(Class type, V value) {
        String key = this.key0(type);
        return this.data.containsKey((Object)key) && this.data.values().contains(value);
    }

    private String key0(Class type) {
        return keyFunction.apply(type);
    }

    public static class Builder<V> {
        private final Map<String, V> data = new LinkedHashMap<String, V>();
        private final Map<String, Class> types = new LinkedHashMap<String, Class>();

        private Builder() {
        }

        public Builder put(Class type, V value) {
            String key = (String)keyFunction.apply(type);
            this.data.put(key, value);
            this.types.put(key, type);
            return this;
        }

        public ImmutableDtoMap<V> build() {
            return new ImmutableDtoMap(ImmutableMap.copyOf(this.data), (ImmutableMap<String, Class>)ImmutableMap.copyOf(this.types));
        }

        public V get(Class<?> type) {
            return this.data.get(type);
        }
    }
}

