/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.spi.context;

import fr.ird.observe.binder.referential.ReferentialDtoReferenceBinder;
import fr.ird.observe.dto.reference.DtoReferenceDefinition;
import fr.ird.observe.dto.reference.ReferentialDtoReference;
import fr.ird.observe.dto.referential.ReferentialDto;
import fr.ird.observe.dto.referential.ReferentialLocale;
import fr.ird.observe.spi.context.DtoContext;
import fr.ird.observe.spi.initializer.DtoReferencesInitializerSupport;

public class ReferentialDtoContext<D extends ReferentialDto, R extends ReferentialDtoReference<D, R>>
implements DtoContext<D, R> {
    private final Class<D> dtoType;
    private final Class<R> referenceType;
    private final ReferentialDtoReferenceBinder<D, R> referenceBinder;
    private final DtoReferenceDefinition<D, R> referenceDefinition;

    public ReferentialDtoContext(Class<D> dtoType, DtoReferencesInitializerSupport modelHelper) {
        this.dtoType = dtoType;
        this.referenceType = modelHelper.getDtoToReferenceClassMapping().forReferential(dtoType);
        this.referenceBinder = modelHelper.getReferentialBinders().get(dtoType);
        this.referenceDefinition = modelHelper.getReferentialReferenceSetDefinition().get(dtoType);
    }

    @Override
    public Class<D> toDtoType() {
        return this.dtoType;
    }

    @Override
    public Class<R> toReferenceType() {
        return this.referenceType;
    }

    @Override
    public ReferentialDtoReferenceBinder<D, R> toReferenceBinder() {
        return this.referenceBinder;
    }

    @Override
    public DtoReferenceDefinition<D, R> toReferenceDefinition() {
        return this.referenceDefinition;
    }

    @Override
    public R toReference(ReferentialLocale referentialLocale, D dto) {
        return (R)((ReferentialDtoReference)this.referenceBinder.toReference(referentialLocale, dto));
    }
}

