/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.navigation.tree;

import fr.ird.observe.dto.IdDto;
import fr.ird.observe.dto.reference.DtoReference;
import fr.ird.observe.navigation.model.DtoModelNavigationNodeSupport;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public interface ReferenceNode<D extends IdDto, R extends DtoReference<D, R>>
extends MutableTreeNode {
    public static <D extends IdDto, R extends DtoReference<D, R>, N extends ReferenceNode<D, R>> N up(Class<R> referenceType, MutableTreeNode node) {
        return (N)ReferenceNode.upToReferenceNode(referenceType, node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>, N extends ReferenceNode<D, R>> N up(MutableTreeNode node) {
        return (N)ReferenceNode.upToFirstReferenceNode(node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>, N extends ReferenceNode<D, R>> N down(Class<R> referenceType, String id, MutableTreeNode node) {
        return (N)ReferenceNode.downToReferenceNode(referenceType, id, node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>, N extends ReferenceNode<D, R>> N down(Class<R> referenceType, MutableTreeNode node) {
        return (N)ReferenceNode.downToFirstReferenceNode(referenceType, node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> ReferenceNode<D, R> upToReferenceNode(Class<R> referenceType, MutableTreeNode node) {
        for (MutableTreeNode result = Objects.requireNonNull(node); result != null; result = (MutableTreeNode)result.getParent()) {
            ReferenceNode referenceNode;
            if (!(result instanceof ReferenceNode) || !(referenceNode = (ReferenceNode)result).getReferenceReferenceType().equals(referenceType)) continue;
            return referenceNode;
        }
        throw new IllegalStateException("Can't go up reference node of type: " + referenceType.getName() + " from node: " + node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> ReferenceNode<D, R> upToFirstReferenceNode(MutableTreeNode node) {
        for (MutableTreeNode result = Objects.requireNonNull(node); result != null; result = (MutableTreeNode)result.getParent()) {
            if (!(result instanceof ReferenceNode)) continue;
            return (ReferenceNode)result;
        }
        throw new IllegalStateException("Can't go up reference node from node: " + node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> ReferenceNode<D, R> downToFirstReferenceNode(Class<R> referenceType, MutableTreeNode node) {
        ReferenceNode referenceNode;
        if (node instanceof ReferenceNode && (referenceNode = (ReferenceNode)node).getReferenceReferenceType().equals(referenceType)) {
            return referenceNode;
        }
        Enumeration<? extends TreeNode> children = Objects.requireNonNull(node).children();
        while (children.hasMoreElements()) {
            ReferenceNode referenceNode2;
            MutableTreeNode childrenNode = (MutableTreeNode)children.nextElement();
            if (!(childrenNode instanceof ReferenceNode) || !(referenceNode2 = (ReferenceNode)childrenNode).getReferenceReferenceType().equals(referenceType)) continue;
            return referenceNode2;
        }
        throw new IllegalStateException("Can't go down reference node of type: " + referenceType.getName() + " from node: " + node);
    }

    public static <D extends IdDto, R extends DtoReference<D, R>> ReferenceNode<D, R> downToReferenceNode(Class<R> referenceType, String id, MutableTreeNode node) {
        ReferenceNode referenceNode;
        if (node instanceof ReferenceNode && (referenceNode = (ReferenceNode)node).getReferenceReferenceType().equals(referenceType)) {
            return referenceNode;
        }
        Enumeration<? extends TreeNode> children = Objects.requireNonNull(node).children();
        while (children.hasMoreElements()) {
            ReferenceNode referenceNode2;
            MutableTreeNode childrenNode = (MutableTreeNode)children.nextElement();
            if (!(childrenNode instanceof ReferenceNode) || !(referenceNode2 = (ReferenceNode)childrenNode).getReferenceReferenceType().equals(referenceType) || !((IdDto)referenceNode2.getReference()).getId().equals(id)) continue;
            return referenceNode2;
        }
        throw new IllegalStateException("Can't go down reference node of type: " + referenceType.getName() + " from node: " + node);
    }

    public Class<D> getReferenceDtoType();

    public Class<R> getReferenceReferenceType();

    public R getReference();

    public DtoModelNavigationNodeSupport<?> getSelectNode();

    public DtoModelNavigationNodeSupport<?> getEditNode();

    public TreeNode[] getPath();
}

