/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.navigation.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.ird.observe.dto.IdDto;
import io.ultreia.java4all.bean.JavaBean;
import java.util.Objects;

public interface DtoModelNavigationNode<D extends IdDto>
extends JavaBean {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_ENABLED = "enabled";

    public Class<D> getType();

    public String getModel();

    public int getLevel();

    public boolean accept(IdDto var1);

    public String getId();

    public void setId(String var1);

    public DtoModelNavigationNode<?> getParent();

    public ImmutableList<DtoModelNavigationNode<?>> getChildren();

    public <N extends DtoModelNavigationNode<?>> void init(N var1, ImmutableList<DtoModelNavigationNode<?>> var2);

    default public DtoModelNavigationNode<?> getRoot() {
        return this.isRoot() ? this : this.getParent().getRoot();
    }

    default public boolean isRoot() {
        return this.getParent() == null;
    }

    default public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    default public boolean isEnabled() {
        return this.getId() != null;
    }

    default public boolean isDisabled() {
        return !this.isEnabled();
    }

    default public boolean acceptModel(String model) {
        return Objects.equals(this.getModel(), model);
    }

    default public void copyTo(DtoModelNavigationNode<?> targetNode) {
        targetNode.setId(this.getId());
        DtoModelNavigationNode<?> parent = this.getParent();
        DtoModelNavigationNode<?> targetNodeParent = targetNode.getParent();
        if (parent != null) {
            parent.copyTo(targetNodeParent);
        }
    }

    default public <N extends DtoModelNavigationNode<?>> void getIds(ImmutableList.Builder<N> builder) {
        if (this.isEnabled()) {
            builder.add((Object)this);
            for (DtoModelNavigationNode child : this.getChildren()) {
                child.getIds(builder);
            }
        }
    }

    default public DtoModelNavigationNode<?> upToSharedAncestor(DtoModelNavigationNode<?> otherNode) {
        if (!this.acceptModel(otherNode.getModel())) {
            return null;
        }
        if (this.isRoot()) {
            return null;
        }
        ImmutableMap otherNodesToRootMapping = Maps.uniqueIndex(otherNode.getNodesToRoot(), DtoModelNavigationNode::getType);
        for (DtoModelNavigationNode thisNode : this.getParent().getNodesToRoot()) {
            DtoModelNavigationNode otherOptionalNode = (DtoModelNavigationNode)otherNodesToRootMapping.get(thisNode.getType());
            if (otherOptionalNode == null) continue;
            return thisNode;
        }
        return null;
    }

    public <N extends DtoModelNavigationNode<?>> ImmutableList<N> getNodesFromAncestor(DtoModelNavigationNode<?> var1);

    public <N extends DtoModelNavigationNode<?>> ImmutableList<N> getNodesToAncestor(DtoModelNavigationNode<?> var1);

    default public <N extends DtoModelNavigationNode<?>> ImmutableList<N> getNodesFromRoot() {
        return this.getNodesFromAncestor(this.getRoot());
    }

    default public <N extends DtoModelNavigationNode<?>> ImmutableList<N> getNodesToRoot() {
        return this.getNodesToAncestor(this.getRoot());
    }
}

