/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.navigation.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import fr.ird.observe.dto.IdDto;
import fr.ird.observe.navigation.model.DtoModelNavigationModel;
import fr.ird.observe.navigation.model.DtoModelNavigationNode;
import io.ultreia.java4all.bean.AbstractJavaBean;
import io.ultreia.java4all.lang.Objects2;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class DtoModelNavigationAggregateModel
extends AbstractJavaBean {
    public static final String PROPERTY_ENABLED = "enabled";
    private final ImmutableList<DtoModelNavigationModel<?>> models;
    private transient boolean enabled;

    @SafeVarargs
    public DtoModelNavigationAggregateModel(Class<? extends DtoModelNavigationModel<?>> ... models) {
        ImmutableList.Builder modelsBuilder = ImmutableList.builder();
        for (UnmodifiableIterator model : models) {
            modelsBuilder.add(Objects2.newInstance((Class)model));
        }
        this.models = modelsBuilder.build();
        for (DtoModelNavigationModel model : this.models) {
            model.addPropertyChangeListener(PROPERTY_ENABLED, e -> this.updateEnabled());
        }
        this.updateEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public <M extends DtoModelNavigationModel<?>> Optional<M> forModelType(Class<M> type) {
        Objects.requireNonNull(type);
        return this.models.stream().filter(e -> Objects.equals(type, e.getClass())).findFirst();
    }

    private void updateEnabled() {
        boolean oldValue = this.isEnabled();
        this.enabled = this.models.stream().anyMatch(DtoModelNavigationModel::isEnabled);
        this.firePropertyChange(PROPERTY_ENABLED, oldValue, this.enabled);
    }

    public ImmutableList<DtoModelNavigationModel<?>> getModels() {
        return this.models;
    }

    public <D extends IdDto> Optional<DtoModelNavigationNode<D>> forDtoType(Class<D> dtoType) {
        Objects.requireNonNull(dtoType);
        for (DtoModelNavigationModel model : this.models) {
            DtoModelNavigationNode<D> node = model.getDtoNode(dtoType);
            if (node == null) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public <D extends IdDto> Optional<DtoModelNavigationNode<D>> forNavigationNode(DtoModelNavigationNode<?> source) {
        Objects.requireNonNull(source);
        for (DtoModelNavigationModel model : this.models) {
            DtoModelNavigationNode node;
            if (!model.acceptModel(source.getModel()) || (node = model.getNavigationNode(source)) == null) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public <N extends DtoModelNavigationNode> Optional<N> forNodeType(Class<N> nodeType) {
        Objects.requireNonNull(nodeType);
        for (DtoModelNavigationModel model : this.models) {
            N node = model.getNode(nodeType);
            if (node == null) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public void load(DtoModelNavigationAggregateModel model) {
        for (DtoModelNavigationModel navigationModel : model.getModels()) {
            for (DtoModelNavigationNode node : navigationModel.getNodesWithIds()) {
                ((DtoModelNavigationNode)this.forNodeType(node.getClass()).orElseThrow(IllegalStateException::new)).setId(node.getId());
            }
        }
    }

    public ImmutableList<? extends DtoModelNavigationModel<?>> getEnabledModels() {
        return ImmutableList.copyOf((Collection)this.getModels().stream().filter(DtoModelNavigationModel::isEnabled).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DtoModelNavigationAggregateModel that = (DtoModelNavigationAggregateModel)((Object)o);
        return Objects.equals(this.models, that.models);
    }

    public int hashCode() {
        return Objects.hash(this.models);
    }

    public int count() {
        return this.models.stream().mapToInt(DtoModelNavigationModel::count).sum();
    }

    public void clearModel() {
        this.models.forEach(DtoModelNavigationModel::clearModel);
    }
}

